/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.DecompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;

public class TestResponseContentEncoding {
    @Test
    public void testContentEncodingNoEntity() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        BasicHttpContext context = new BasicHttpContext();
        ResponseContentEncoding interceptor = new ResponseContentEncoding();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        HttpEntity entity = response.getEntity();
        Assert.assertNull((Object)entity);
    }

    @Test
    public void testNoContentEncoding() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        StringEntity original = new StringEntity("plain stuff");
        response.setEntity((HttpEntity)original);
        BasicHttpContext context = new BasicHttpContext();
        ResponseContentEncoding interceptor = new ResponseContentEncoding();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        HttpEntity entity = response.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)(entity instanceof StringEntity));
    }

    @Test
    public void testGzipContentEncoding() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        StringEntity original = new StringEntity("encoded stuff");
        original.setContentEncoding("GZip");
        response.setEntity((HttpEntity)original);
        BasicHttpContext context = new BasicHttpContext();
        ResponseContentEncoding interceptor = new ResponseContentEncoding();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        HttpEntity entity = response.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)(entity instanceof DecompressingEntity));
    }

    @Test
    public void testGzipContentEncodingZeroLength() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        StringEntity original = new StringEntity("");
        original.setContentEncoding("GZip");
        response.setEntity((HttpEntity)original);
        BasicHttpContext context = new BasicHttpContext();
        ResponseContentEncoding interceptor = new ResponseContentEncoding();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        HttpEntity entity = response.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)(entity instanceof StringEntity));
    }

    @Test
    public void testXGzipContentEncoding() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        StringEntity original = new StringEntity("encoded stuff");
        original.setContentEncoding("x-gzip");
        response.setEntity((HttpEntity)original);
        BasicHttpContext context = new BasicHttpContext();
        ResponseContentEncoding interceptor = new ResponseContentEncoding();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        HttpEntity entity = response.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)(entity instanceof DecompressingEntity));
    }

    @Test
    public void testDeflateContentEncoding() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        StringEntity original = new StringEntity("encoded stuff");
        original.setContentEncoding("deFlaTe");
        response.setEntity((HttpEntity)original);
        BasicHttpContext context = new BasicHttpContext();
        ResponseContentEncoding interceptor = new ResponseContentEncoding();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        HttpEntity entity = response.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)(entity instanceof DecompressingEntity));
    }

    @Test
    public void testIdentityContentEncoding() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        StringEntity original = new StringEntity("encoded stuff");
        original.setContentEncoding("identity");
        response.setEntity((HttpEntity)original);
        BasicHttpContext context = new BasicHttpContext();
        ResponseContentEncoding interceptor = new ResponseContentEncoding();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        HttpEntity entity = response.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)(entity instanceof StringEntity));
    }

    @Test(expected=HttpException.class)
    public void testUnknownContentEncoding() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        StringEntity original = new StringEntity("encoded stuff");
        original.setContentEncoding("whatever");
        response.setEntity((HttpEntity)original);
        BasicHttpContext context = new BasicHttpContext();
        ResponseContentEncoding interceptor = new ResponseContentEncoding(false);
        interceptor.process((HttpResponse)response, (HttpContext)context);
    }

    @Test
    public void testContentEncodingRequestParameter() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        StringEntity original = new StringEntity("encoded stuff");
        original.setContentEncoding("GZip");
        response.setEntity((HttpEntity)original);
        RequestConfig config = RequestConfig.custom().setDecompressionEnabled(false).build();
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.request-config", (Object)config);
        ResponseContentEncoding interceptor = new ResponseContentEncoding();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        HttpEntity entity = response.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertFalse((boolean)(entity instanceof GzipDecompressingEntity));
    }
}

