/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.http.HttpHost;
import org.apache.http.config.Lookup;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.UnsupportedSchemeException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHttpClientConnectionOperator {
    private ManagedHttpClientConnection conn;
    private Socket socket;
    private ConnectionSocketFactory plainSocketFactory;
    private LayeredConnectionSocketFactory sslSocketFactory;
    private Lookup<ConnectionSocketFactory> socketFactoryRegistry;
    private SchemePortResolver schemePortResolver;
    private DnsResolver dnsResolver;
    private DefaultHttpClientConnectionOperator connectionOperator;

    @Before
    public void setup() throws Exception {
        this.conn = (ManagedHttpClientConnection)Mockito.mock(ManagedHttpClientConnection.class);
        this.socket = (Socket)Mockito.mock(Socket.class);
        this.plainSocketFactory = (ConnectionSocketFactory)Mockito.mock(ConnectionSocketFactory.class);
        this.sslSocketFactory = (LayeredConnectionSocketFactory)Mockito.mock(LayeredConnectionSocketFactory.class);
        this.socketFactoryRegistry = (Lookup)Mockito.mock(Lookup.class);
        this.schemePortResolver = (SchemePortResolver)Mockito.mock(SchemePortResolver.class);
        this.dnsResolver = (DnsResolver)Mockito.mock(DnsResolver.class);
        this.connectionOperator = new DefaultHttpClientConnectionOperator(this.socketFactoryRegistry, this.schemePortResolver, this.dnsResolver);
    }

    @Test
    public void testConnect() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("somehost");
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 0});
        InetAddress ip1 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        InetAddress ip2 = InetAddress.getByAddress(new byte[]{127, 0, 0, 2});
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{ip1, ip2});
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(host)).thenReturn((Object)80);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket(Mockito.anyInt(), (Socket)Mockito.any(), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(true).setSoReuseAddress(true).setSoTimeout(5000).setTcpNoDelay(true).setSoLinger(50).build();
        InetSocketAddress localAddress = new InetSocketAddress(local, 0);
        this.connectionOperator.connect(this.conn, host, localAddress, 1000, socketConfig, (HttpContext)context);
        ((Socket)Mockito.verify((Object)this.socket)).setKeepAlive(true);
        ((Socket)Mockito.verify((Object)this.socket)).setReuseAddress(true);
        ((Socket)Mockito.verify((Object)this.socket)).setSoTimeout(5000);
        ((Socket)Mockito.verify((Object)this.socket)).setSoLinger(true, 50);
        ((Socket)Mockito.verify((Object)this.socket)).setTcpNoDelay(true);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory)).connectSocket(1000, this.socket, host, new InetSocketAddress(ip1, 80), localAddress, (HttpContext)context);
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).bind(this.socket);
    }

    @Test(expected=ConnectTimeoutException.class)
    public void testConnectTimeout() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("somehost");
        InetAddress ip1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress ip2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{ip1, ip2});
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(host)).thenReturn((Object)80);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket(Mockito.anyInt(), (Socket)Mockito.any(), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (HttpContext)Mockito.any())).thenThrow(new Throwable[]{new SocketTimeoutException()});
        this.connectionOperator.connect(this.conn, host, null, 1000, SocketConfig.DEFAULT, (HttpContext)context);
    }

    @Test(expected=HttpHostConnectException.class)
    public void testConnectFailure() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("somehost");
        InetAddress ip1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress ip2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{ip1, ip2});
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(host)).thenReturn((Object)80);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket(Mockito.anyInt(), (Socket)Mockito.any(), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (HttpContext)Mockito.any())).thenThrow(new Throwable[]{new ConnectException()});
        this.connectionOperator.connect(this.conn, host, null, 1000, SocketConfig.DEFAULT, (HttpContext)context);
    }

    @Test
    public void testConnectFailover() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("somehost");
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 0});
        InetAddress ip1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress ip2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{ip1, ip2});
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(host)).thenReturn((Object)80);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket(Mockito.anyInt(), (Socket)Mockito.any(), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.eq((Object)new InetSocketAddress(ip1, 80)), (InetSocketAddress)Mockito.any(), (HttpContext)Mockito.any())).thenThrow(new Throwable[]{new ConnectException()});
        Mockito.when((Object)this.plainSocketFactory.connectSocket(Mockito.anyInt(), (Socket)Mockito.any(), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.eq((Object)new InetSocketAddress(ip2, 80)), (InetSocketAddress)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        InetSocketAddress localAddress = new InetSocketAddress(local, 0);
        this.connectionOperator.connect(this.conn, host, localAddress, 1000, SocketConfig.DEFAULT, (HttpContext)context);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory)).connectSocket(1000, this.socket, host, new InetSocketAddress(ip2, 80), localAddress, (HttpContext)context);
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)3))).bind(this.socket);
    }

    @Test
    public void testConnectExplicitAddress() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 0});
        InetAddress ip = InetAddress.getByAddress(new byte[]{127, 0, 0, 23});
        HttpHost host = new HttpHost(ip);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(host)).thenReturn((Object)80);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket(Mockito.anyInt(), (Socket)Mockito.any(), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        InetSocketAddress localAddress = new InetSocketAddress(local, 0);
        this.connectionOperator.connect(this.conn, host, localAddress, 1000, SocketConfig.DEFAULT, (HttpContext)context);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory)).connectSocket(1000, this.socket, host, new InetSocketAddress(ip, 80), localAddress, (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.never())).resolve(Mockito.anyString());
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).bind(this.socket);
    }

    @Test
    public void testUpgrade() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("somehost", -1, "https");
        Mockito.when((Object)this.socketFactoryRegistry.lookup("https")).thenReturn((Object)this.sslSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(host)).thenReturn((Object)443);
        Mockito.when((Object)this.sslSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.sslSocketFactory.createLayeredSocket((Socket)Mockito.any(), (String)Mockito.eq((Object)"somehost"), Mockito.eq((int)443), (HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        this.connectionOperator.upgrade(this.conn, host, (HttpContext)context);
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).bind(this.socket);
    }

    @Test(expected=UnsupportedSchemeException.class)
    public void testUpgradeUpsupportedScheme() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("somehost", -1, "httpsssss");
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        this.connectionOperator.upgrade(this.conn, host, (HttpContext)context);
    }

    @Test(expected=UnsupportedSchemeException.class)
    public void testUpgradeNonLayeringScheme() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("somehost", -1, "http");
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        this.connectionOperator.upgrade(this.conn, host, (HttpContext)context);
    }
}

