/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import org.apache.http.Consts;
import org.apache.http.impl.auth.NTLMEngineImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestNTLMEngineImpl {
    @Test
    public void testMD4() throws Exception {
        TestNTLMEngineImpl.checkMD4("", "31d6cfe0d16ae931b73c59d7e0c089c0");
        TestNTLMEngineImpl.checkMD4("a", "bde52cb31de33e46245e05fbdbd6fb24");
        TestNTLMEngineImpl.checkMD4("abc", "a448017aaf21d8525fc10ae87aa6729d");
        TestNTLMEngineImpl.checkMD4("message digest", "d9130a8164549fe818874806e1c7014b");
        TestNTLMEngineImpl.checkMD4("abcdefghijklmnopqrstuvwxyz", "d79e1c308aa5bbcdeea8ed63df412da9");
        TestNTLMEngineImpl.checkMD4("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "043f8582f241db351ce627e153e7f0e4");
        TestNTLMEngineImpl.checkMD4("12345678901234567890123456789012345678901234567890123456789012345678901234567890", "e33b4ddc9c38f2199c3e7b164fcc0536");
    }

    static byte toNibble(char c) {
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 97 + 10);
        }
        return (byte)(c - 48);
    }

    static byte[] toBytes(String hex) {
        byte[] rval = new byte[hex.length() / 2];
        for (int i = 0; i < rval.length; ++i) {
            rval[i] = (byte)(TestNTLMEngineImpl.toNibble(hex.charAt(i * 2)) << 4 | TestNTLMEngineImpl.toNibble(hex.charAt(i * 2 + 1)));
        }
        return rval;
    }

    static void checkMD4(String input, String hexOutput) throws Exception {
        NTLMEngineImpl.MD4 md4 = new NTLMEngineImpl.MD4();
        md4.update(input.getBytes(Consts.ASCII));
        byte[] answer = md4.getOutput();
        byte[] correctAnswer = TestNTLMEngineImpl.toBytes(hexOutput);
        if (answer.length != correctAnswer.length) {
            throw new Exception("Answer length disagrees for MD4('" + input + "')");
        }
        for (int i = 0; i < answer.length; ++i) {
            if (answer[i] == correctAnswer[i]) continue;
            throw new Exception("Answer value for MD4('" + input + "') disagrees at position " + Integer.toString(i));
        }
    }

    @Test
    public void testLMResponse() throws Exception {
        NTLMEngineImpl.CipherGen gen = new NTLMEngineImpl.CipherGen(null, null, "SecREt01", TestNTLMEngineImpl.toBytes("0123456789abcdef"), null, null, null, null, null, null);
        TestNTLMEngineImpl.checkArraysMatch(TestNTLMEngineImpl.toBytes("c337cd5cbd44fc9782a667af6d427c6de67c20c2d3e77c56"), gen.getLMResponse());
    }

    @Test
    public void testNTLMResponse() throws Exception {
        NTLMEngineImpl.CipherGen gen = new NTLMEngineImpl.CipherGen(null, null, "SecREt01", TestNTLMEngineImpl.toBytes("0123456789abcdef"), null, null, null, null, null, null);
        TestNTLMEngineImpl.checkArraysMatch(TestNTLMEngineImpl.toBytes("25a98c1c31e81847466b29b2df4680f39958fb8c213a9cc6"), gen.getNTLMResponse());
    }

    @Test
    public void testLMv2Response() throws Exception {
        NTLMEngineImpl.CipherGen gen = new NTLMEngineImpl.CipherGen("DOMAIN", "user", "SecREt01", TestNTLMEngineImpl.toBytes("0123456789abcdef"), "DOMAIN", null, TestNTLMEngineImpl.toBytes("ffffff0011223344"), TestNTLMEngineImpl.toBytes("ffffff0011223344"), null, null);
        TestNTLMEngineImpl.checkArraysMatch(TestNTLMEngineImpl.toBytes("d6e6152ea25d03b7c6ba6629c2d6aaf0ffffff0011223344"), gen.getLMv2Response());
    }

    @Test
    public void testNTLMv2Response() throws Exception {
        NTLMEngineImpl.CipherGen gen = new NTLMEngineImpl.CipherGen("DOMAIN", "user", "SecREt01", TestNTLMEngineImpl.toBytes("0123456789abcdef"), "DOMAIN", TestNTLMEngineImpl.toBytes("02000c0044004f004d00410049004e0001000c005300450052005600450052000400140064006f006d00610069006e002e0063006f006d00030022007300650072007600650072002e0064006f006d00610069006e002e0063006f006d0000000000"), TestNTLMEngineImpl.toBytes("ffffff0011223344"), TestNTLMEngineImpl.toBytes("ffffff0011223344"), null, TestNTLMEngineImpl.toBytes("0090d336b734c301"));
        TestNTLMEngineImpl.checkArraysMatch(TestNTLMEngineImpl.toBytes("01010000000000000090d336b734c301ffffff00112233440000000002000c0044004f004d00410049004e0001000c005300450052005600450052000400140064006f006d00610069006e002e0063006f006d00030022007300650072007600650072002e0064006f006d00610069006e002e0063006f006d000000000000000000"), gen.getNTLMv2Blob());
        TestNTLMEngineImpl.checkArraysMatch(TestNTLMEngineImpl.toBytes("cbabbca713eb795d04c97abc01ee498301010000000000000090d336b734c301ffffff00112233440000000002000c0044004f004d00410049004e0001000c005300450052005600450052000400140064006f006d00610069006e002e0063006f006d00030022007300650072007600650072002e0064006f006d00610069006e002e0063006f006d000000000000000000"), gen.getNTLMv2Response());
    }

    @Test
    public void testLM2SessionResponse() throws Exception {
        NTLMEngineImpl.CipherGen gen = new NTLMEngineImpl.CipherGen("DOMAIN", "user", "SecREt01", TestNTLMEngineImpl.toBytes("0123456789abcdef"), "DOMAIN", TestNTLMEngineImpl.toBytes("02000c0044004f004d00410049004e0001000c005300450052005600450052000400140064006f006d00610069006e002e0063006f006d00030022007300650072007600650072002e0064006f006d00610069006e002e0063006f006d0000000000"), TestNTLMEngineImpl.toBytes("ffffff0011223344"), TestNTLMEngineImpl.toBytes("ffffff0011223344"), null, TestNTLMEngineImpl.toBytes("0090d336b734c301"));
        TestNTLMEngineImpl.checkArraysMatch(TestNTLMEngineImpl.toBytes("ffffff001122334400000000000000000000000000000000"), gen.getLM2SessionResponse());
    }

    @Test
    public void testNTLM2SessionResponse() throws Exception {
        NTLMEngineImpl.CipherGen gen = new NTLMEngineImpl.CipherGen("DOMAIN", "user", "SecREt01", TestNTLMEngineImpl.toBytes("0123456789abcdef"), "DOMAIN", TestNTLMEngineImpl.toBytes("02000c0044004f004d00410049004e0001000c005300450052005600450052000400140064006f006d00610069006e002e0063006f006d00030022007300650072007600650072002e0064006f006d00610069006e002e0063006f006d0000000000"), TestNTLMEngineImpl.toBytes("ffffff0011223344"), TestNTLMEngineImpl.toBytes("ffffff0011223344"), null, TestNTLMEngineImpl.toBytes("0090d336b734c301"));
        TestNTLMEngineImpl.checkArraysMatch(TestNTLMEngineImpl.toBytes("10d550832d12b2ccb79d5ad1f4eed3df82aca4c3681dd455"), gen.getNTLM2SessionResponse());
    }

    @Test
    public void testNTLMUserSessionKey() throws Exception {
        NTLMEngineImpl.CipherGen gen = new NTLMEngineImpl.CipherGen("DOMAIN", "user", "SecREt01", TestNTLMEngineImpl.toBytes("0123456789abcdef"), "DOMAIN", TestNTLMEngineImpl.toBytes("02000c0044004f004d00410049004e0001000c005300450052005600450052000400140064006f006d00610069006e002e0063006f006d00030022007300650072007600650072002e0064006f006d00610069006e002e0063006f006d0000000000"), TestNTLMEngineImpl.toBytes("ffffff0011223344"), TestNTLMEngineImpl.toBytes("ffffff0011223344"), null, TestNTLMEngineImpl.toBytes("0090d336b734c301"));
        TestNTLMEngineImpl.checkArraysMatch(TestNTLMEngineImpl.toBytes("3f373ea8e4af954f14faa506f8eebdc4"), gen.getNTLMUserSessionKey());
    }

    @Test
    public void testType1Message() throws Exception {
        new NTLMEngineImpl();
        NTLMEngineImpl.getType1Message((String)"myhost", (String)"mydomain");
    }

    @Test
    public void testType3Message() throws Exception {
        new NTLMEngineImpl();
        NTLMEngineImpl.getType3Message((String)"me", (String)"mypassword", (String)"myhost", (String)"mydomain", (byte[])TestNTLMEngineImpl.toBytes("0001020304050607"), (int)-1, null, null);
        new NTLMEngineImpl();
        NTLMEngineImpl.getType3Message((String)"me", (String)"mypassword", (String)"myhost", (String)"mydomain", (byte[])TestNTLMEngineImpl.toBytes("0001020304050607"), (int)-1, (String)"mytarget", (byte[])TestNTLMEngineImpl.toBytes("02000c0044004f004d00410049004e0001000c005300450052005600450052000400140064006f006d00610069006e002e0063006f006d00030022007300650072007600650072002e0064006f006d00610069006e002e0063006f006d0000000000"));
    }

    @Test
    public void testRC4() throws Exception {
        TestNTLMEngineImpl.checkArraysMatch(TestNTLMEngineImpl.toBytes("e37f97f2544f4d7e"), NTLMEngineImpl.RC4((byte[])TestNTLMEngineImpl.toBytes("0a003602317a759a"), (byte[])TestNTLMEngineImpl.toBytes("2785f595293f3e2813439d73a223810d")));
    }

    static void checkArraysMatch(byte[] a1, byte[] a2) throws Exception {
        Assert.assertEquals((long)a1.length, (long)a2.length);
        for (int i = 0; i < a1.length; ++i) {
            Assert.assertEquals((long)a1[i], (long)a2[i]);
        }
    }
}

