/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.localserver.LocalServerTestBase;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicConnectionManager
extends LocalServerTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasics() throws Exception {
        this.clientBuilder.setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager());
        HttpHost target = this.start();
        HttpGet get = new HttpGet("/random/1024");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)get);
        try {
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        finally {
            response.close();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testConnectionStillInUse() throws Exception {
        this.clientBuilder.setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager());
        HttpHost target = this.start();
        HttpGet get1 = new HttpGet("/random/1024");
        this.httpclient.execute(target, (HttpRequest)get1);
        HttpGet get2 = new HttpGet("/random/1024");
        this.httpclient.execute(target, (HttpRequest)get2);
    }
}

