/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.sql.Timestamp;
import java.util.Calendar;
import org.h2.value.ValueTimestamp;

public class GridH2Utils {
    private static final int SHIFT_YEAR = 9;
    private static final int SHIFT_MONTH = 5;
    private static final Calendar staticCalendar = Calendar.getInstance();
    private static final ThreadLocal<Calendar> localCalendar = new ThreadLocal();

    public static Calendar getLocalCalendar() {
        Calendar res = localCalendar.get();
        if (res == null) {
            res = (Calendar)staticCalendar.clone();
            localCalendar.set(res);
        }
        return res;
    }

    public static ValueTimestamp toValueTimestamp(Timestamp timestamp) {
        long ms = timestamp.getTime();
        long nanos = timestamp.getNanos() % 1000000;
        Calendar calendar = GridH2Utils.getLocalCalendar();
        calendar.clear();
        calendar.setTimeInMillis(ms);
        long dateValue = GridH2Utils.dateValueFromCalendar(calendar);
        return ValueTimestamp.fromDateValueAndNanos((long)dateValue, (long)(nanos += GridH2Utils.nanosFromCalendar(calendar)));
    }

    private static long nanosFromCalendar(Calendar cal) {
        int h = cal.get(11);
        int m = cal.get(12);
        int s = cal.get(13);
        int millis = cal.get(14);
        return ((((long)h * 60L + (long)m) * 60L + (long)s) * 1000L + (long)millis) * 1000000L;
    }

    private static long dateValueFromCalendar(Calendar cal) {
        int year = GridH2Utils.getYear(cal);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        return (long)year << 9 | (long)(month << 5) | (long)day;
    }

    private static int getYear(Calendar calendar) {
        int year = calendar.get(1);
        if (calendar.get(0) == 0) {
            year = 1 - year;
        }
        return year;
    }
}

