/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunctionType;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.command.Parser;
import org.h2.util.StatementBuilder;
import org.h2.value.ValueString;

public class GridSqlFunction
extends GridSqlElement {
    private static final Map<String, GridSqlFunctionType> TYPE_MAP = new HashMap<String, GridSqlFunctionType>();
    private final String schema;
    private final String name;
    protected final GridSqlFunctionType type;
    private String castType;

    public GridSqlFunction(GridSqlFunctionType type) {
        this(null, type, type.functionName());
    }

    private GridSqlFunction(String schema, GridSqlFunctionType type, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            type = GridSqlFunctionType.UNKNOWN_FUNCTION;
        }
        this.schema = schema;
        this.name = name;
        this.type = type;
    }

    public GridSqlFunction(String schema, String name) {
        this(schema, TYPE_MAP.get(name), name);
    }

    public GridSqlFunction setCastType(String castType) {
        this.castType = castType;
        return this;
    }

    @Override
    public String getSQL() {
        StatementBuilder buff = new StatementBuilder();
        if (this.schema != null) {
            buff.append(Parser.quoteIdentifier((String)this.schema)).append('.');
        }
        buff.append(Parser.quoteIdentifier((String)this.name));
        if (this.type == GridSqlFunctionType.CASE) {
            if (!this.children.isEmpty()) {
                buff.append(" ").append(this.child().getSQL());
            }
            int len = this.children.size() - 1;
            for (int i = 1; i < len; i += 2) {
                buff.append(" WHEN ").append(this.child(i).getSQL());
                buff.append(" THEN ").append(this.child(i + 1).getSQL());
            }
            if (this.children.size() % 2 == 0) {
                buff.append(" ELSE ").append(this.child(this.children.size() - 1).getSQL());
            }
            return buff.append(" END").toString();
        }
        buff.append('(');
        if (this.type == GridSqlFunctionType.CAST) {
            assert (!F.isEmpty((String)this.castType)) : this.castType;
            assert (this.size() == 1);
            buff.append(this.child().getSQL()).append(" AS ").append(this.castType);
        } else if (this.type == GridSqlFunctionType.CONVERT) {
            assert (!F.isEmpty((String)this.castType)) : this.castType;
            assert (this.size() == 1);
            buff.append(this.child().getSQL()).append(',').append(this.castType);
        } else if (this.type == GridSqlFunctionType.EXTRACT) {
            ValueString v = (ValueString)((GridSqlConst)this.child(0)).value();
            buff.append(v.getString()).append(" FROM ").append(this.child(1).getSQL());
        } else {
            for (GridSqlElement e : this.children) {
                buff.appendExceptFirst(", ");
                buff.append(e.getSQL());
            }
        }
        return buff.append(')').toString();
    }

    public String name() {
        return this.name;
    }

    public GridSqlFunctionType type() {
        return this.type;
    }

    static {
        for (GridSqlFunctionType type : GridSqlFunctionType.values()) {
            TYPE_MAP.put(type.name(), type);
        }
    }
}

