/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAggregateFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunctionType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlParameter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSortColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSubquery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;
import org.h2.jdbc.JdbcPreparedStatement;

public class GridSqlQuerySplitter {
    private static final String TABLE_PREFIX = "__T";
    private static final String COLUMN_PREFIX = "__C";
    public static final String TABLE_FUNC_NAME = "__Z0";

    private static String table(int idx) {
        return TABLE_PREFIX + idx;
    }

    private static String columnName(int idx) {
        return COLUMN_PREFIX + idx;
    }

    /*
     * WARNING - void declaration
     */
    public static GridCacheTwoStepQuery split(JdbcPreparedStatement stmt, Object[] params) {
        void var9_10;
        if (params == null) {
            params = GridCacheSqlQuery.EMPTY_PARAMS;
        }
        GridSqlSelect srcQry = GridSqlQueryParser.parse(stmt);
        String mergeTable = "__Z0()";
        GridSqlSelect mapQry = srcQry.clone();
        GridSqlSelect rdcQry = new GridSqlSelect().from(new GridSqlFunction("PUBLIC", TABLE_FUNC_NAME));
        ArrayList<GridSqlElement> mapExps = new ArrayList<GridSqlElement>(srcQry.allExpressions());
        GridSqlElement[] rdcExps = new GridSqlElement[srcQry.select().size()];
        HashSet<String> colNames = new HashSet<String>();
        boolean bl = false;
        int len = mapExps.size();
        while (var9_10 < len) {
            GridSqlQuerySplitter.splitSelectExpression(mapExps, rdcExps, colNames, (int)var9_10);
            ++var9_10;
        }
        mapQry.clearSelect();
        for (GridSqlElement exp : mapExps) {
            mapQry.addSelectExpression(exp);
        }
        for (GridSqlElement rdcExp : rdcExps) {
            rdcQry.addSelectExpression(rdcExp);
        }
        if (!srcQry.groups().isEmpty()) {
            mapQry.clearGroups();
            for (int col : srcQry.groupColumns()) {
                mapQry.addGroupExpression(GridSqlQuerySplitter.column(((GridSqlAlias)mapExps.get(col)).alias()));
            }
            for (int col : srcQry.groupColumns()) {
                rdcQry.addGroupExpression(GridSqlQuerySplitter.column(((GridSqlAlias)mapExps.get(col)).alias()));
            }
        }
        if (srcQry.having() != null) {
            rdcQry.whereAnd(GridSqlQuerySplitter.column(GridSqlQuerySplitter.columnName(srcQry.havingColumn())));
            mapQry.having(null);
        }
        if (!srcQry.sort().isEmpty()) {
            for (GridSqlSortColumn sortCol : srcQry.sort().values()) {
                rdcQry.addSort(GridSqlQuerySplitter.column(((GridSqlAlias)mapExps.get(sortCol.column())).alias()), sortCol);
            }
        }
        if (srcQry.limit() != null) {
            rdcQry.limit(srcQry.limit());
        }
        if (srcQry.offset() != null) {
            mapQry.offset(null);
            rdcQry.offset(srcQry.offset());
        }
        if (srcQry.distinct()) {
            mapQry.distinct(false);
            rdcQry.distinct(true);
        }
        GridCacheTwoStepQuery gridCacheTwoStepQuery = new GridCacheTwoStepQuery(rdcQry.getSQL(), GridSqlQuerySplitter.findParams(rdcQry, params, new ArrayList<Object>()).toArray());
        gridCacheTwoStepQuery.addMapQuery("__Z0()", mapQry.getSQL(), GridSqlQuerySplitter.findParams(mapQry, params, new ArrayList<Object>(params.length)).toArray());
        return gridCacheTwoStepQuery;
    }

    private static List<Object> findParams(GridSqlSelect qry, Object[] params, ArrayList<Object> target) {
        if (params.length == 0) {
            return target;
        }
        for (GridSqlElement el : qry.select()) {
            GridSqlQuerySplitter.findParams(el, params, target);
        }
        GridSqlQuerySplitter.findParams(qry.from(), params, target);
        GridSqlQuerySplitter.findParams(qry.where(), params, target);
        for (GridSqlElement el : qry.groups()) {
            GridSqlQuerySplitter.findParams(el, params, target);
        }
        GridSqlQuerySplitter.findParams(qry.having(), params, target);
        for (GridSqlElement el : qry.sort().keySet()) {
            GridSqlQuerySplitter.findParams(el, params, target);
        }
        GridSqlQuerySplitter.findParams(qry.limit(), params, target);
        GridSqlQuerySplitter.findParams(qry.offset(), params, target);
        return target;
    }

    private static void findParams(GridSqlElement el, Object[] params, ArrayList<Object> target) {
        if (el == null) {
            return;
        }
        if (el instanceof GridSqlParameter) {
            int idx = ((GridSqlParameter)el).index();
            while (target.size() < idx) {
                target.add(null);
            }
            Object param = params[idx];
            if (idx == target.size()) {
                target.add(param);
            } else {
                target.set(idx, param);
            }
        } else if (el instanceof GridSqlSubquery) {
            GridSqlQuerySplitter.findParams(((GridSqlSubquery)el).select(), params, target);
        } else {
            for (GridSqlElement child : el) {
                GridSqlQuerySplitter.findParams(child, params, target);
            }
        }
    }

    private static void splitSelectExpression(List<GridSqlElement> mapSelect, GridSqlElement[] rdcSelect, Set<String> colNames, int idx) {
        GridSqlElement el = mapSelect.get(idx);
        GridSqlAlias alias = null;
        if (el instanceof GridSqlAlias) {
            alias = (GridSqlAlias)el;
            el = alias.child();
        }
        if (el instanceof GridSqlAggregateFunction) {
            GridSqlElement rdcAgg;
            GridSqlElement mapAgg;
            GridSqlAggregateFunction agg = (GridSqlAggregateFunction)el;
            String mapAggAlias = GridSqlQuerySplitter.columnName(idx);
            switch (agg.type()) {
                case AVG: {
                    GridSqlElement cntMapAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), GridSqlFunctionType.COUNT).addChild(agg.child());
                    String cntMapAggAlias = GridSqlQuerySplitter.columnName(mapSelect.size());
                    cntMapAgg = GridSqlQuerySplitter.alias(cntMapAggAlias, cntMapAgg);
                    mapSelect.add(cntMapAgg);
                    mapAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), GridSqlFunctionType.AVG).addChild(GridSqlQuerySplitter.function(GridSqlFunctionType.CAST).setCastType("DOUBLE").addChild(agg.child()));
                    GridSqlElement sumUpRdc = GridSqlQuerySplitter.aggregate(false, GridSqlFunctionType.SUM).addChild(GridSqlQuerySplitter.op(GridSqlOperationType.MULTIPLY, GridSqlQuerySplitter.column(mapAggAlias), GridSqlQuerySplitter.column(cntMapAggAlias)));
                    GridSqlElement sumDownRdc = GridSqlQuerySplitter.aggregate(false, GridSqlFunctionType.SUM).addChild(GridSqlQuerySplitter.column(cntMapAggAlias));
                    rdcAgg = GridSqlQuerySplitter.op(GridSqlOperationType.DIVIDE, sumUpRdc, sumDownRdc);
                    break;
                }
                case SUM: 
                case MAX: 
                case MIN: {
                    mapAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), agg.type()).addChild(agg.child());
                    rdcAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), agg.type()).addChild(GridSqlQuerySplitter.column(mapAggAlias));
                    break;
                }
                case COUNT_ALL: 
                case COUNT: {
                    mapAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), agg.type());
                    if (agg.type() == GridSqlFunctionType.COUNT) {
                        mapAgg.addChild(agg.child());
                    }
                    rdcAgg = GridSqlQuerySplitter.aggregate(false, GridSqlFunctionType.SUM).addChild(GridSqlQuerySplitter.column(mapAggAlias));
                    rdcAgg = GridSqlQuerySplitter.function(GridSqlFunctionType.CAST).setCastType("BIGINT").addChild(rdcAgg);
                    break;
                }
                default: {
                    throw new IgniteException("Unsupported aggregate: " + (Object)((Object)agg.type()));
                }
            }
            assert (!(mapAgg instanceof GridSqlAlias));
            mapAgg = GridSqlQuerySplitter.alias(mapAggAlias, mapAgg);
            if (alias != null) {
                rdcAgg = GridSqlQuerySplitter.alias(alias.alias(), rdcAgg);
            }
            mapSelect.set(idx, mapAgg);
            rdcSelect[idx] = rdcAgg;
        } else {
            String mapColAlias = GridSqlQuerySplitter.columnName(idx);
            String rdcColAlias = alias == null ? (el instanceof GridSqlColumn ? ((GridSqlColumn)el).columnName() : mapColAlias) : alias.alias();
            mapSelect.set(idx, GridSqlQuerySplitter.alias(mapColAlias, el));
            if (idx < rdcSelect.length) {
                GridSqlElement rdcEl = GridSqlQuerySplitter.column(mapColAlias);
                GridSqlType type = el.expressionResultType();
                if (type != null && type.type() == 20) {
                    rdcEl = GridSqlQuerySplitter.function(GridSqlFunctionType.CAST).setCastType("UUID").addChild(rdcEl);
                }
                if (colNames.add(rdcColAlias)) {
                    rdcEl = GridSqlQuerySplitter.alias(rdcColAlias, rdcEl);
                }
                rdcSelect[idx] = rdcEl;
            }
        }
    }

    private static GridSqlAggregateFunction aggregate(boolean distinct, GridSqlFunctionType type) {
        return new GridSqlAggregateFunction(distinct, type);
    }

    private static GridSqlColumn column(String name) {
        return new GridSqlColumn(null, name, name);
    }

    private static GridSqlAlias alias(String alias, GridSqlElement child) {
        return new GridSqlAlias(alias, child);
    }

    private static GridSqlOperation op(GridSqlOperationType type, GridSqlElement left, GridSqlElement right) {
        return new GridSqlOperation(type, left, right);
    }

    private static GridSqlFunction function(GridSqlFunctionType type) {
        return new GridSqlFunction(type);
    }

    private static GridSqlTable table(String name) {
        return new GridSqlTable(null, name);
    }
}

