/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.managers.communication.GridIoPolicy;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.query.GridQueryCacheObjectsIterator;
import org.apache.ignite.internal.processors.query.h2.GridH2ResultSetIterator;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndex;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeTable;
import org.apache.ignite.internal.processors.query.h2.twostep.GridResultPage;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryFailResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryRequest;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Cursor;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcStatement;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.tools.SimpleResultSet;
import org.h2.tools.SimpleRowSource;
import org.h2.util.MathUtils;
import org.h2.value.DataType;
import org.jsr166.ConcurrentHashMap8;

public class GridReduceQueryExecutor
implements GridMessageListener {
    private GridKernalContext ctx;
    private IgniteH2Indexing h2;
    private IgniteLogger log;
    private final AtomicLong reqIdGen = new AtomicLong();
    private final ConcurrentMap<Long, QueryRun> runs = new ConcurrentHashMap8();
    private static ThreadLocal<GridMergeTable> curFunTbl = new ThreadLocal();
    private static final Constructor<JdbcResultSet> CONSTRUCTOR;

    public void start(GridKernalContext ctx, IgniteH2Indexing h2) throws IgniteCheckedException {
        this.ctx = ctx;
        this.h2 = h2;
        this.log = ctx.log(GridReduceQueryExecutor.class);
        ctx.io().addMessageListener(GridTopic.TOPIC_QUERY, (GridMessageListener)this);
        ctx.event().addLocalEventListener(new GridLocalEventListener(){

            public void onEvent(Event evt) {
                UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
                block0: for (QueryRun r : GridReduceQueryExecutor.this.runs.values()) {
                    for (GridMergeTable tbl : r.tbls) {
                        if (!tbl.getScanIndex(null).hasSource(nodeId)) continue;
                        GridReduceQueryExecutor.this.fail(r, nodeId, "Node left the topology.");
                        continue block0;
                    }
                }
            }
        }, 12, new int[]{11});
        h2.executeStatement("PUBLIC", "CREATE ALIAS __Z0 NOBUFFER FOR \"" + GridReduceQueryExecutor.class.getName() + ".mergeTableFunction\"");
    }

    public void onMessage(UUID nodeId, Object msg) {
        try {
            assert (msg != null);
            ClusterNode node = this.ctx.discovery().node(nodeId);
            boolean processed = true;
            if (msg instanceof GridQueryNextPageResponse) {
                this.onNextPage(node, (GridQueryNextPageResponse)msg);
            } else if (msg instanceof GridQueryFailResponse) {
                this.onFail(node, (GridQueryFailResponse)msg);
            } else {
                processed = false;
            }
            if (processed && this.log.isDebugEnabled()) {
                this.log.debug("Processed response: " + nodeId + "->" + this.ctx.localNodeId() + " " + msg);
            }
        }
        catch (Throwable th) {
            U.error((IgniteLogger)this.log, (Object)("Failed to process message: " + msg), (Throwable)th);
        }
    }

    private void onFail(ClusterNode node, GridQueryFailResponse msg) {
        QueryRun r = (QueryRun)this.runs.get(msg.queryRequestId());
        this.fail(r, node.id(), msg.error());
    }

    private void fail(QueryRun r, UUID nodeId, String msg) {
        if (r != null) {
            r.rmtErr = new CacheException("Failed to execute map query on the node: " + nodeId + ", " + msg);
            while (r.latch.getCount() != 0L) {
                r.latch.countDown();
            }
            for (GridMergeTable tbl : r.tbls) {
                tbl.getScanIndex(null).fail(nodeId);
            }
        }
    }

    private void onNextPage(final ClusterNode node, GridQueryNextPageResponse msg) {
        GridResultPage page;
        final long qryReqId = msg.queryRequestId();
        final int qry = msg.query();
        final QueryRun r = (QueryRun)this.runs.get(qryReqId);
        if (r == null) {
            return;
        }
        final int pageSize = r.pageSize;
        GridMergeIndex idx = ((GridMergeTable)((Object)r.tbls.get(msg.query()))).getScanIndex(null);
        try {
            page = new GridResultPage(node.id(), msg, false){

                @Override
                public void fetchNextPage() {
                    if (r.rmtErr != null) {
                        throw new CacheException("Next page fetch failed.", (Throwable)r.rmtErr);
                    }
                    try {
                        GridQueryNextPageRequest msg0 = new GridQueryNextPageRequest(qryReqId, qry, pageSize);
                        if (node.isLocal()) {
                            GridReduceQueryExecutor.this.h2.mapQueryExecutor().onMessage(GridReduceQueryExecutor.this.ctx.localNodeId(), msg0);
                        } else {
                            GridReduceQueryExecutor.this.ctx.io().send(node, GridTopic.TOPIC_QUERY, (Message)msg0, GridIoPolicy.PUBLIC_POOL);
                        }
                    }
                    catch (IgniteCheckedException e) {
                        throw new CacheException((Throwable)e);
                    }
                }
            };
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)"Error in message.", (Throwable)e);
            this.fail(r, node.id(), "Error in message.");
            return;
        }
        idx.addPage(page);
        if (msg.allRows() != -1) {
            r.latch.countDown();
        }
    }

    public QueryCursor<List<?>> query(GridCacheContext<?, ?> cctx, GridCacheTwoStepQuery qry) {
        long qryReqId = this.reqIdGen.incrementAndGet();
        QueryRun r = new QueryRun();
        r.pageSize = qry.pageSize() <= 0 ? 1000 : qry.pageSize();
        r.tbls = new ArrayList(qry.mapQueries().size());
        String space = cctx.name();
        r.conn = this.h2.connectionForSpace(space);
        ClusterGroup dataNodes = this.ctx.grid().cluster().forDataNodes(space);
        if (cctx.isReplicated()) {
            assert (dataNodes.node(this.ctx.localNodeId()) == null) : "We must be on a client node.";
            dataNodes = dataNodes.forRandom();
        }
        Collection nodes = dataNodes.nodes();
        for (GridCacheSqlQuery mapQry : qry.mapQueries()) {
            GridMergeTable tbl;
            try {
                tbl = this.createFunctionTable((JdbcConnection)r.conn, mapQry);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException((Throwable)e);
            }
            GridMergeIndex idx = tbl.getScanIndex(null);
            for (ClusterNode node : nodes) {
                idx.addSource(node.id());
            }
            r.tbls.add(tbl);
            curFunTbl.set(tbl);
        }
        r.latch = new CountDownLatch(r.tbls.size() * nodes.size());
        this.runs.put(qryReqId, r);
        try {
            this.send(nodes, (Message)new GridQueryRequest(qryReqId, r.pageSize, space, qry.mapQueries(), this.ctx.config().getMarshaller().marshal((Object)qry.mapQueries())));
            r.latch.await();
            if (r.rmtErr != null) {
                throw new CacheException("Failed to run map query remotely.", (Throwable)r.rmtErr);
            }
            GridCacheSqlQuery rdc = qry.reduceQuery();
            ResultSet res = this.h2.executeSqlQueryWithTimer(space, r.conn, rdc.query(), F.asList((Object[])rdc.parameters()));
            for (GridMergeTable tbl : r.tbls) {
                if (tbl.getScanIndex(null).fetchedAll()) continue;
                this.send(nodes, (Message)new GridQueryCancelRequest(qryReqId));
            }
            QueryCursorImpl queryCursorImpl = new QueryCursorImpl((Iterator)new GridQueryCacheObjectsIterator((Iterator)((Object)new Iter(res)), cctx, cctx.keepPortable()));
            return queryCursorImpl;
        }
        catch (InterruptedException | RuntimeException | IgniteCheckedException e) {
            U.closeQuiet((AutoCloseable)r.conn);
            if (e instanceof CacheException) {
                throw (CacheException)e;
            }
            throw new CacheException("Failed to run reduce query locally.", e);
        }
        finally {
            if (!this.runs.remove(qryReqId, r)) {
                U.warn((IgniteLogger)this.log, (Object)("Query run was already removed: " + qryReqId));
            }
            curFunTbl.remove();
        }
    }

    private void send(Collection<ClusterNode> nodes, Message msg) throws IgniteCheckedException {
        for (ClusterNode node : nodes) {
            if (!node.isLocal()) continue;
            if (nodes.size() > 1) {
                ArrayList<ClusterNode> remotes = new ArrayList<ClusterNode>(nodes.size() - 1);
                for (ClusterNode node0 : nodes) {
                    if (node0.isLocal()) continue;
                    remotes.add(node0);
                }
                assert (remotes.size() == nodes.size() - 1);
                this.ctx.io().send(remotes, GridTopic.TOPIC_QUERY, msg, GridIoPolicy.PUBLIC_POOL);
            }
            this.h2.mapQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            return;
        }
        this.ctx.io().send(nodes, GridTopic.TOPIC_QUERY, msg, GridIoPolicy.PUBLIC_POOL);
    }

    private void dropTable(Connection conn, String tblName) throws SQLException {
        try (Statement s = conn.createStatement();){
            s.execute("DROP TABLE " + tblName);
        }
    }

    public static ResultSet mergeTableFunction(JdbcConnection c) throws Exception {
        GridMergeTable tbl = curFunTbl.get();
        Session ses = (Session)c.getSession();
        String url = c.getMetaData().getURL();
        final Cursor cursor = url.charAt(5) == 'c' ? null : tbl.getScanIndex(ses).find(ses, null, null);
        final Column[] cols = tbl.getColumns();
        SimpleResultSet rs = new SimpleResultSet(cursor == null ? null : new SimpleRowSource(){

            public Object[] readRow() throws SQLException {
                if (!cursor.next()) {
                    return null;
                }
                Row r = cursor.get();
                Object[] row = new Object[cols.length];
                for (int i = 0; i < row.length; ++i) {
                    row[i] = r.getValue(i).getObject();
                }
                return row;
            }

            public void close() {
            }

            public void reset() throws SQLException {
                throw new SQLException("Unsupported.");
            }
        }){

            public byte[] getBytes(int colIdx) throws SQLException {
                assert (cursor != null);
                return cursor.get().getValue(colIdx - 1).getBytes();
            }

            public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
                throw new UnsupportedOperationException();
            }

            public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
                throw new UnsupportedOperationException();
            }
        };
        for (Column col : cols) {
            rs.addColumn(col.getName(), DataType.convertTypeToSQLType((int)col.getType()), MathUtils.convertLongToInt((long)col.getPrecision()), col.getScale());
        }
        return rs;
    }

    private static ArrayList<Column> generateColumnsFromQuery(Query asQuery) {
        int columnCount = asQuery.getColumnCount();
        ArrayList expressions = asQuery.getExpressions();
        ArrayList<Column> cols = new ArrayList<Column>();
        for (int i = 0; i < columnCount; ++i) {
            int scale;
            Expression expr = (Expression)expressions.get(i);
            int type = expr.getType();
            String name = expr.getAlias();
            long precision = expr.getPrecision();
            int displaySize = expr.getDisplaySize();
            DataType dt = DataType.getDataType((int)type);
            if (precision > 0L && (dt.defaultPrecision == 0L || dt.defaultPrecision > precision && dt.defaultPrecision < 127L)) {
                precision = dt.defaultPrecision;
            }
            if ((scale = expr.getScale()) > 0 && (dt.defaultScale == 0 || dt.defaultScale > scale && (long)dt.defaultScale < precision)) {
                scale = dt.defaultScale;
            }
            if ((long)scale > precision) {
                precision = scale;
            }
            Column col = new Column(name, type, precision, scale, displaySize);
            cols.add(col);
        }
        return cols;
    }

    private GridMergeTable createFunctionTable(JdbcConnection conn, GridCacheSqlQuery qry) throws IgniteCheckedException {
        try {
            Session ses = (Session)conn.getSession();
            CreateTableData data = new CreateTableData();
            data.tableName = "T___";
            data.schema = ses.getDatabase().getSchema(ses.getCurrentSchemaName());
            data.create = true;
            data.columns = GridReduceQueryExecutor.generateColumnsFromQuery((Query)ses.prepare(qry.query(), false));
            return new GridMergeTable(data);
        }
        catch (Exception e) {
            U.closeQuiet((AutoCloseable)conn);
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    private GridMergeTable createTable(Connection conn, GridCacheSqlQuery qry) throws IgniteCheckedException {
        try {
            try (PreparedStatement s = conn.prepareStatement("CREATE LOCAL TEMPORARY TABLE " + qry.alias() + " ENGINE \"" + GridMergeTable.Engine.class.getName() + "\" " + " AS SELECT * FROM (" + qry.query() + ") WHERE FALSE");){
                this.h2.bindParameters(s, F.asList((Object[])qry.parameters()));
                s.execute();
            }
            return GridMergeTable.Engine.getCreated();
        }
        catch (SQLException e) {
            U.closeQuiet((AutoCloseable)conn);
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    static {
        try {
            CONSTRUCTOR = JdbcResultSet.class.getDeclaredConstructor(JdbcConnection.class, JdbcStatement.class, ResultInterface.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            CONSTRUCTOR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Check H2 version in classpath.", e);
        }
    }

    private static class Iter
    extends GridH2ResultSetIterator<List<?>> {
        private static final long serialVersionUID = 0L;

        protected Iter(ResultSet data) throws IgniteCheckedException {
            super(data);
        }

        @Override
        protected List<?> createRow() {
            ArrayList res = new ArrayList(this.row.length);
            Collections.addAll(res, this.row);
            return res;
        }
    }

    private static class QueryRun {
        private List<GridMergeTable> tbls;
        private CountDownLatch latch;
        private Connection conn;
        private int pageSize;
        private volatile CacheException rmtErr;

        private QueryRun() {
        }
    }
}

