/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.UUID;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.h2.value.Value;

public class GridResultPage {
    private final UUID src;
    private final GridQueryNextPageResponse res;
    private final int rowsInPage;
    private Iterator<Value[]> rows;
    private boolean last;

    public GridResultPage(final GridKernalContext ctx, UUID src, final GridQueryNextPageResponse res) {
        assert (src != null);
        this.src = src;
        this.res = res;
        if (res != null) {
            Collection plainRows = res.plainRows();
            if (plainRows != null) {
                this.rowsInPage = plainRows.size();
                this.rows = this.rowsInPage == 0 || ((Value[])((ArrayList)plainRows).get(0)).length == res.columns() ? plainRows.iterator() : F.iterator((Iterable)plainRows, (IgniteClosure)new IgniteClosure<Object, Value[]>(){

                    public Value[] apply(Object o) {
                        Value[] row = (Value[])o;
                        assert (row.length >= res.columns());
                        return Arrays.copyOfRange(row, 0, res.columns());
                    }
                }, (boolean)true, (IgnitePredicate[])new IgnitePredicate[0]);
            } else {
                final int cols = res.columns();
                this.rowsInPage = res.values().size() / cols;
                final Iterator valsIter = res.values().iterator();
                this.rows = new Iterator<Value[]>(){
                    int rowIdx;

                    @Override
                    public boolean hasNext() {
                        return this.rowIdx < GridResultPage.this.rowsInPage;
                    }

                    @Override
                    public Value[] next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.rowIdx;
                        try {
                            return GridH2ValueMessageFactory.fillArray(valsIter, new Value[cols], ctx);
                        }
                        catch (IgniteCheckedException e) {
                            throw new CacheException((Throwable)e);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        } else {
            this.rowsInPage = 0;
            this.rows = Collections.emptyIterator();
        }
    }

    public boolean isFail() {
        return false;
    }

    public boolean isLast() {
        return this.last;
    }

    public boolean isDummyLast() {
        return this.last && this.res == null;
    }

    public GridResultPage setLast(boolean last) {
        this.last = last;
        return this;
    }

    public int rowsInPage() {
        return this.rowsInPage;
    }

    public Iterator<Value[]> rows() {
        Iterator<Value[]> r = this.rows;
        assert (r != null);
        this.rows = null;
        return r;
    }

    public UUID source() {
        return this.src;
    }

    public int segmentId() {
        return this.res.segmentId();
    }

    public GridQueryNextPageResponse response() {
        return this.res;
    }

    public void fetchNextPage() {
        throw new CacheException("Failed to fetch data from node: " + this.src);
    }

    public String toString() {
        return S.toString(GridResultPage.class, (Object)this);
    }
}

