/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.websession;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePartialUpdateException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.websession.WebSession;
import org.apache.ignite.cache.websession.WebSessionListener;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public class WebSessionFilter
implements Filter {
    public static final String WEB_SES_NAME_PARAM = "IgniteWebSessionsGridName";
    public static final String WEB_SES_CACHE_NAME_PARAM = "IgniteWebSessionsCacheName";
    public static final String WEB_SES_MAX_RETRIES_ON_FAIL_NAME_PARAM = "IgniteWebSessionsMaximumRetriesOnFail";
    public static final int DFLT_MAX_RETRIES_ON_FAIL = 3;
    private IgniteCache<String, WebSession> cache;
    private IgniteTransactions txs;
    private WebSessionListener lsnr;
    private IgniteLogger log;
    private ServletContext ctx;
    private IgniteClosure<String, String> sesIdTransformer;
    private boolean txEnabled;

    public void init(FilterConfig cfg) throws ServletException {
        int retries;
        this.ctx = cfg.getServletContext();
        String gridName = (String)U.firstNotNull((Object[])new String[]{cfg.getInitParameter(WEB_SES_NAME_PARAM), this.ctx.getInitParameter(WEB_SES_NAME_PARAM)});
        String cacheName = (String)U.firstNotNull((Object[])new String[]{cfg.getInitParameter(WEB_SES_CACHE_NAME_PARAM), this.ctx.getInitParameter(WEB_SES_CACHE_NAME_PARAM)});
        String retriesStr = (String)U.firstNotNull((Object[])new String[]{cfg.getInitParameter(WEB_SES_MAX_RETRIES_ON_FAIL_NAME_PARAM), this.ctx.getInitParameter(WEB_SES_MAX_RETRIES_ON_FAIL_NAME_PARAM)});
        try {
            retries = retriesStr != null ? Integer.parseInt(retriesStr) : 3;
        }
        catch (NumberFormatException e) {
            throw new IgniteException("Maximum number of retries parameter is invalid: " + retriesStr, (Throwable)e);
        }
        Ignite webSesIgnite = G.ignite((String)gridName);
        if (webSesIgnite == null) {
            throw new IgniteException("Grid for web sessions caching is not started (is it configured?): " + gridName);
        }
        this.txs = webSesIgnite.transactions();
        this.log = webSesIgnite.log();
        if (webSesIgnite == null) {
            throw new IgniteException("Grid for web sessions caching is not started (is it configured?): " + gridName);
        }
        this.cache = webSesIgnite.cache(cacheName);
        if (this.cache == null) {
            throw new IgniteException("Cache for web sessions is not started (is it configured?): " + cacheName);
        }
        CacheConfiguration cacheCfg = (CacheConfiguration)this.cache.getConfiguration(CacheConfiguration.class);
        if (cacheCfg.getWriteSynchronizationMode() == CacheWriteSynchronizationMode.FULL_ASYNC) {
            throw new IgniteException("Cache for web sessions cannot be in FULL_ASYNC mode: " + cacheName);
        }
        if (!cacheCfg.isEagerTtl()) {
            throw new IgniteException("Cache for web sessions cannot operate with lazy TTL. Consider setting eagerTtl to true for cache: " + cacheName);
        }
        if (cacheCfg.getCacheMode() == CacheMode.LOCAL) {
            U.quietAndWarn((IgniteLogger)webSesIgnite.log(), (Object)("Using LOCAL cache for web sessions caching (this is only OK in test mode): " + cacheName));
        }
        if (cacheCfg.getCacheMode() == CacheMode.PARTITIONED && cacheCfg.getAtomicityMode() != CacheAtomicityMode.ATOMIC) {
            U.quietAndWarn((IgniteLogger)webSesIgnite.log(), (Object)("Using " + cacheCfg.getAtomicityMode() + " atomicity for web sessions " + "caching (switch to ATOMIC mode for better performance)"));
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Started web sessions caching [gridName=" + gridName + ", cacheName=" + cacheName + ", maxRetriesOnFail=" + retries + ']');
        }
        this.txEnabled = cacheCfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL;
        this.lsnr = new WebSessionListener(webSesIgnite, this.cache, retries);
        String srvInfo = this.ctx.getServerInfo();
        if (srvInfo != null && srvInfo.contains("WebLogic")) {
            this.sesIdTransformer = new C1<String, String>(){

                public String apply(String s) {
                    int idx = s.indexOf(33);
                    if (idx < 0 || idx == s.length() - 1) {
                        return s;
                    }
                    if ((idx = s.indexOf(33, idx + 1)) < 0) {
                        return s;
                    }
                    return s.substring(0, idx);
                }
            };
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block18: {
            assert (this.ctx != null);
            if (req instanceof HttpServletRequest) {
                HttpServletRequest httpReq = (HttpServletRequest)req;
                String sesId = null;
                try {
                    if (this.txEnabled) {
                        try (Transaction tx = this.txs.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                            sesId = this.doFilter0(httpReq, res, chain);
                            tx.commit();
                            break block18;
                        }
                    }
                    sesId = this.doFilter0(httpReq, res, chain);
                }
                catch (Exception e) {
                    U.error((IgniteLogger)this.log, (Object)("Failed to update web session: " + sesId), (Throwable)e);
                }
            } else {
                chain.doFilter(req, res);
            }
        }
    }

    private String doFilter0(HttpServletRequest httpReq, ServletResponse res, FilterChain chain) throws IOException, ServletException, CacheException {
        Collection<T2<String, Object>> updates;
        HttpSession ses;
        WebSession cached;
        String sesId = httpReq.getRequestedSessionId();
        if (sesId != null) {
            cached = (WebSession)this.cache.get((Object)sesId);
            if (cached != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Using cached session for ID: " + sesId);
                }
                if (cached.isNew()) {
                    cached = new WebSession(cached, false);
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cached session was invalidated and doesn't exist: " + sesId);
                }
                if ((ses = httpReq.getSession(false)) != null) {
                    try {
                        ses.invalidate();
                    }
                    catch (IllegalStateException ignore) {
                        // empty catch block
                    }
                }
                cached = this.createSession((HttpServletRequest)httpReq);
            }
        } else {
            cached = this.createSession((HttpServletRequest)httpReq);
            sesId = cached.getId();
        }
        assert (cached != null);
        cached.servletContext(this.ctx);
        cached.listener(this.lsnr);
        cached.resetUpdates();
        httpReq = new RequestWrapper((HttpServletRequest)httpReq, cached);
        chain.doFilter((ServletRequest)httpReq, res);
        ses = httpReq.getSession(false);
        if (ses != null && ses instanceof WebSession && (updates = ((WebSession)ses).updates()) != null) {
            this.lsnr.updateAttributes(ses.getId(), updates, ses.getMaxInactiveInterval());
        }
        return sesId;
    }

    private WebSession createSession(HttpServletRequest httpReq) {
        String sesId;
        HttpSession ses = httpReq.getSession(true);
        String string = sesId = this.sesIdTransformer != null ? (String)this.sesIdTransformer.apply((Object)ses.getId()) : ses.getId();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Session created: " + sesId);
        }
        WebSession cached = new WebSession(ses, true);
        try {
            while (true) {
                try {
                    IgniteCache cache0;
                    if (cached.getMaxInactiveInterval() > 0) {
                        long ttl = cached.getMaxInactiveInterval() * 1000;
                        ModifiedExpiryPolicy plc = new ModifiedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, ttl));
                        cache0 = this.cache.withExpiryPolicy((ExpiryPolicy)plc);
                    } else {
                        cache0 = this.cache;
                    }
                    WebSession old = (WebSession)cache0.getAndPutIfAbsent((Object)sesId, (Object)cached);
                    if (old != null && (cached = old).isNew()) {
                        cached = new WebSession(cached, false);
                    }
                }
                catch (CachePartialUpdateException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug(e.getMessage());
                    continue;
                }
                break;
            }
        }
        catch (CacheException e) {
            throw new IgniteException("Failed to save session: " + sesId, (Throwable)e);
        }
        return cached;
    }

    public String toString() {
        return S.toString(WebSessionFilter.class, (Object)this);
    }

    private static class RequestWrapper
    extends HttpServletRequestWrapper {
        private final WebSession ses;

        private RequestWrapper(HttpServletRequest req, WebSession ses) {
            super(req);
            assert (ses != null);
            this.ses = ses;
        }

        public HttpSession getSession(boolean create) {
            return this.ses;
        }

        public HttpSession getSession() {
            return this.ses;
        }
    }
}

