/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.websession;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.MutableEntry;
import javax.servlet.http.HttpSession;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CachePartialUpdateException;
import org.apache.ignite.cache.websession.WebSession;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

class WebSessionListener {
    private static final long RETRY_DELAY = 1L;
    private final IgniteCache<String, WebSession> cache;
    private final int retries;
    private final IgniteLogger log;

    WebSessionListener(Ignite ignite, IgniteCache<String, WebSession> cache, int retries) {
        assert (ignite != null);
        assert (cache != null);
        this.cache = cache;
        this.retries = retries > 0 ? retries : 1;
        this.log = ignite.log();
    }

    public void destroySession(String sesId) {
        assert (sesId != null);
        try {
            if (this.cache.remove((Object)sesId) && this.log.isDebugEnabled()) {
                this.log.debug("Session destroyed: " + sesId);
            }
        }
        catch (CacheException e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to remove session: " + sesId), (Throwable)e);
        }
    }

    public void updateAttributes(String sesId, Collection<T2<String, Object>> updates, int maxInactiveInterval) {
        assert (sesId != null);
        assert (updates != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Session attributes updated [id=" + sesId + ", updates=" + updates + ']');
        }
        try {
            for (int i = 0; i < this.retries; ++i) {
                try {
                    IgniteCache cache0;
                    if (maxInactiveInterval > 0) {
                        long ttl = maxInactiveInterval * 1000;
                        ModifiedExpiryPolicy plc = new ModifiedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, ttl));
                        cache0 = this.cache.withExpiryPolicy((ExpiryPolicy)plc);
                    } else {
                        cache0 = this.cache;
                    }
                    cache0.invoke((Object)sesId, (EntryProcessor)new AttributesProcessor(updates), new Object[0]);
                    break;
                }
                catch (CachePartialUpdateException ignored) {
                    if (i == this.retries - 1) {
                        U.warn((IgniteLogger)this.log, (Object)("Failed to apply updates for session (maximum number of retries exceeded) [sesId=" + sesId + ", retries=" + this.retries + ']'));
                        continue;
                    }
                    U.warn((IgniteLogger)this.log, (Object)("Failed to apply updates for session (will retry): " + sesId));
                    U.sleep((long)1L);
                    continue;
                }
            }
        }
        catch (CacheException | IgniteInterruptedCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to update session attributes [id=" + sesId + ']'), (Throwable)e);
        }
    }

    public String toString() {
        return S.toString(WebSessionListener.class, (Object)this);
    }

    private static class AttributesProcessor
    implements EntryProcessor<String, WebSession, Void>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private Collection<T2<String, Object>> updates;

        public AttributesProcessor() {
        }

        AttributesProcessor(Collection<T2<String, Object>> updates) {
            assert (updates != null);
            this.updates = updates;
        }

        public Void process(MutableEntry<String, WebSession> entry, Object ... args) {
            if (!entry.exists()) {
                return null;
            }
            WebSession ses = new WebSession((HttpSession)entry.getValue());
            for (T2<String, Object> update : this.updates) {
                String name = (String)update.get1();
                assert (name != null);
                Object val = update.get2();
                if (val != null) {
                    ses.setAttribute(name, val);
                    continue;
                }
                ses.removeAttribute(name);
            }
            entry.setValue((Object)ses);
            return null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeCollection((ObjectOutput)out, this.updates);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.updates = U.readCollection((ObjectInput)in);
        }
    }
}

