/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.startup.servlet;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;

public class ServletStartup
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private static boolean loaded;
    private static final String cfgFilePathParam = "cfgFilePath";
    private Collection<String> gridNames = new ArrayList<String>();

    public void init() throws ServletException {
        if (loaded) {
            return;
        }
        String cfgFile = this.getServletConfig().getInitParameter(cfgFilePathParam);
        if (cfgFile == null) {
            throw new ServletException("Failed to read property: cfgFilePath");
        }
        URL cfgUrl = U.resolveIgniteUrl((String)cfgFile);
        if (cfgUrl == null) {
            throw new ServletException("Failed to find Spring configuration file (path provided should be either absolute, relative to IGNITE_HOME, or relative to META-INF folder): " + cfgFile);
        }
        try {
            IgniteBiTuple t = IgnitionEx.loadConfigurations((URL)cfgUrl);
            Collection cfgs = (Collection)t.get1();
            if (cfgs == null) {
                throw new ServletException("Failed to find a single grid factory configuration in: " + cfgUrl);
            }
            for (IgniteConfiguration cfg : cfgs) {
                assert (cfg != null);
                IgniteConfiguration adapter = new IgniteConfiguration(cfg);
                Ignite ignite = IgnitionEx.start((IgniteConfiguration)adapter, (GridSpringResourceContext)((GridSpringResourceContext)t.get2()));
                if (ignite == null) continue;
                this.gridNames.add(ignite.name());
            }
        }
        catch (IgniteCheckedException e) {
            for (String name : this.gridNames) {
                G.stop((String)name, (boolean)true);
            }
            throw new ServletException("Failed to start Ignite.", (Throwable)e);
        }
        loaded = true;
    }

    public void destroy() {
        for (String name : this.gridNames) {
            G.stop((String)name, (boolean)true);
        }
        loaded = false;
    }

    public String toString() {
        return S.toString(ServletStartup.class, (Object)((Object)this));
    }
}

