/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.reporpter;

import com.google.gson.Gson;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.common.reporpter.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractReporter<T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(AbstractReporter.class);
    public static final String AGENT_HTTP_APPLICATION_JSON = "application/json";
    private static final Gson gson = new Gson();
    private static final int DEFAULT_CORE_POOL_SIZE = 1;
    private static final int DEFAULT_MAX_POOL_SIZE = 2;
    private static final int DEFAULT_SYNC_SEND_QUEUE_SIZE = 10000;
    private static CloseableHttpClient httpClient;
    private final Class<?> clazz = Response.class;
    private ThreadPoolExecutor pool;
    private String serverUrl;

    public AbstractReporter(String serverUrl) {
        this(serverUrl, 1, 2, 10000, null);
    }

    public AbstractReporter(CloseableHttpClient httpClient, String serverUrl) {
        this(httpClient, serverUrl, 1, 2, 10000, null);
    }

    public AbstractReporter(String serverUrl, int corePoolSize, int maximumPoolsize, int syncSendQueueSize, RejectedExecutionHandler rejectedExecutionHandler) {
        this.serverUrl = serverUrl;
        if (httpClient == null) {
            RequestConfig requestConfig = RequestConfig.custom().build();
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
            httpClient = httpClientBuilder.build();
        }
        if (rejectedExecutionHandler == null) {
            rejectedExecutionHandler = new ThreadPoolExecutor.DiscardOldestPolicy();
        }
        this.pool = new ThreadPoolExecutor(corePoolSize, maximumPoolsize, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(syncSendQueueSize), Executors.defaultThreadFactory(), rejectedExecutionHandler);
    }

    public AbstractReporter(CloseableHttpClient httpClient, String serverUrl, int corePoolSize, int maximumPoolSize, int syncSendQueueSize, RejectedExecutionHandler rejectedExecutionHandler) {
        this(serverUrl, corePoolSize, maximumPoolSize, syncSendQueueSize, rejectedExecutionHandler);
        AbstractReporter.httpClient = httpClient;
    }

    public Response syncReportData(T data, String serverUrl) throws Exception {
        if (StringUtils.isEmpty((CharSequence)serverUrl)) {
            LOGGER.warn("Report config log server url is empty, so config log can not be reported!");
            return null;
        }
        HttpPost httpPost = new HttpPost(serverUrl);
        String returnStr = null;
        try {
            StringEntity stringEntity = new StringEntity(gson.toJson(data));
            stringEntity.setContentType(AGENT_HTTP_APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)stringEntity);
            returnStr = this.executeHttpPost(httpPost);
            return this.parse(returnStr);
        }
        catch (Exception e) {
            LOGGER.error("syncReportData has exception returnStr = {}, e:", returnStr, (Object)e);
            throw e;
        }
    }

    public Response syncReportData(T data) throws Exception {
        return this.syncReportData(data, this.serverUrl);
    }

    public String executeHttpPost(HttpPost httpPost) throws Exception {
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        if (response == null) {
            return null;
        }
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    public Future<Response> asyncReportData(T data, String serverUrl) {
        CompletableFuture<Response> completableFuture = new CompletableFuture<Response>();
        if (this.pool != null) {
            this.pool.execute(new RunTask(completableFuture, data, serverUrl));
        } else {
            completableFuture.completeExceptionally(new Exception("Send pool is null!"));
        }
        return completableFuture;
    }

    public Future<Response> asyncReportData(T data) {
        return this.asyncReportData(data, this.serverUrl);
    }

    public Response parse(String json) throws Exception {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        return (Response)gson.fromJson(json, Response.class);
    }

    class RunTask
    implements Runnable {
        private CompletableFuture<Response> completableFuture;
        private T data;
        private String url;

        public RunTask(CompletableFuture<Response> completableFuture, T data, String url) {
            this.completableFuture = completableFuture;
            this.data = data;
            this.url = url;
        }

        @Override
        public void run() {
            try {
                this.completableFuture.complete(AbstractReporter.this.syncReportData(this.data, this.url));
            }
            catch (Exception e) {
                this.completableFuture.completeExceptionally(e);
            }
        }
    }
}

