/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.validation.SaveValidation;
import org.apache.inlong.manager.common.validation.UpdateByIdValidation;
import org.apache.inlong.manager.common.validation.UpdateByKeyValidation;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Inlong cluster request")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="type")
public abstract class ClusterRequest {
    @ApiModelProperty(value="Primary key")
    @NotNull(groups={UpdateByIdValidation.class}, message="id cannot be null")
    private @NotNull(groups={UpdateByIdValidation.class}, message="id cannot be null") Integer id;
    @ApiModelProperty(value="Cluster name")
    @Pattern(regexp="^[A-Za-z0-9_-]{1,128}$", message="only supports letters, numbers, '-', or '_'")
    private @Pattern(regexp="^[A-Za-z0-9_-]{1,128}$", message="only supports letters, numbers, '-', or '_'") String name;
    @ApiModelProperty(value="Cluster display name, just for display")
    @Length(min=1, max=128, message="length must be between 1 and 128")
    private @Length(min=1, max=128, message="length must be between 1 and 128") String displayName;
    @ApiModelProperty(value="Cluster type, including TUBEMQ, PULSAR, KAFKA, DATAPROXY, etc.")
    @NotBlank(message="cluster type cannot be blank")
    @Length(min=1, max=20, message="length must be between 1 and 20")
    private @NotBlank(message="cluster type cannot be blank") @Length(min=1, max=20, message="length must be between 1 and 20") String type;
    @ApiModelProperty(value="Cluster tags, separated by commas")
    @NotBlank(groups={SaveValidation.class, UpdateByKeyValidation.class}, message="clusterTags cannot be blank")
    @Length(max=512, message="length must be less than or equal to 512")
    private @NotBlank(groups={SaveValidation.class, UpdateByKeyValidation.class}, message="clusterTags cannot be blank") @Length(max=512, message="length must be less than or equal to 512") String clusterTags;
    @ApiModelProperty(value="Cluster url")
    @Length(max=512, message="length must be less than or equal to 512")
    @Pattern(regexp="^((?!\\s).)*$", message="not supports blank in url")
    private @Length(max=512, message="length must be less than or equal to 512") @Pattern(regexp="^((?!\\s).)*$", message="not supports blank in url") String url;
    @ApiModelProperty(value="Extension tag")
    @Length(max=128, message="length must be less than or equal to 128")
    private @Length(max=128, message="length must be less than or equal to 128") String extTag = "default=true";
    @ApiModelProperty(value="Cluster token")
    @Length(max=512, message="length must be less than or equal to 512")
    private @Length(max=512, message="length must be less than or equal to 512") String token;
    @ApiModelProperty(value="Cluster heartbeat info")
    @Length(max=163840, message="length must be less than or equal to 163840")
    private @Length(max=163840, message="length must be less than or equal to 163840") String heartbeat;
    @ApiModelProperty(value="Extended params")
    @Length(max=163840, message="length must be less than or equal to 163840")
    private @Length(max=163840, message="length must be less than or equal to 163840") String extParams;
    @ApiModelProperty(value="Description of the cluster")
    @Length(max=256, message="length must be less than or equal to 256")
    private @Length(max=256, message="length must be less than or equal to 256") String description;
    @ApiModelProperty(value="Name of responsible person, separated by commas")
    @Length(max=512, message="length must be less than or equal to 512")
    private @Length(max=512, message="length must be less than or equal to 512") String inCharges;
    @ApiModelProperty(value="Version number")
    @NotNull(groups={UpdateByIdValidation.class, UpdateByKeyValidation.class}, message="version cannot be null")
    private @NotNull(groups={UpdateByIdValidation.class, UpdateByKeyValidation.class}, message="version cannot be null") Integer version;

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getType() {
        return this.type;
    }

    public String getClusterTags() {
        return this.clusterTags;
    }

    public String getUrl() {
        return this.url;
    }

    public String getExtTag() {
        return this.extTag;
    }

    public String getToken() {
        return this.token;
    }

    public String getHeartbeat() {
        return this.heartbeat;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setClusterTags(String clusterTags) {
        this.clusterTags = clusterTags;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setExtTag(String extTag) {
        this.extTag = extTag;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setHeartbeat(String heartbeat) {
        this.heartbeat = heartbeat;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterRequest)) {
            return false;
        }
        ClusterRequest other = (ClusterRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$clusterTags = this.getClusterTags();
        String other$clusterTags = other.getClusterTags();
        if (this$clusterTags == null ? other$clusterTags != null : !this$clusterTags.equals(other$clusterTags)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$extTag = this.getExtTag();
        String other$extTag = other.getExtTag();
        if (this$extTag == null ? other$extTag != null : !this$extTag.equals(other$extTag)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$heartbeat = this.getHeartbeat();
        String other$heartbeat = other.getHeartbeat();
        if (this$heartbeat == null ? other$heartbeat != null : !this$heartbeat.equals(other$heartbeat)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        if (this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        return !(this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $clusterTags = this.getClusterTags();
        result = result * 59 + ($clusterTags == null ? 43 : $clusterTags.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $extTag = this.getExtTag();
        result = result * 59 + ($extTag == null ? 43 : $extTag.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $heartbeat = this.getHeartbeat();
        result = result * 59 + ($heartbeat == null ? 43 : $heartbeat.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        return result;
    }

    public String toString() {
        return "ClusterRequest(id=" + this.getId() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", type=" + this.getType() + ", clusterTags=" + this.getClusterTags() + ", url=" + this.getUrl() + ", extTag=" + this.getExtTag() + ", token=" + this.getToken() + ", heartbeat=" + this.getHeartbeat() + ", extParams=" + this.getExtParams() + ", description=" + this.getDescription() + ", inCharges=" + this.getInCharges() + ", version=" + this.getVersion() + ")";
    }

    public ClusterRequest() {
    }

    public ClusterRequest(Integer id, String name, String displayName, String type, String clusterTags, String url, String extTag, String token, String heartbeat, String extParams, String description, String inCharges, Integer version) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.type = type;
        this.clusterTags = clusterTags;
        this.url = url;
        this.extTag = extTag;
        this.token = token;
        this.heartbeat = heartbeat;
        this.extParams = extParams;
        this.description = description;
        this.inCharges = inCharges;
        this.version = version;
    }
}

