/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.ClickHouseProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.DorisProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.ElasticsearchProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.GreenplumProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.HBaseProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.HDFSProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.HiveProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.HudiProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.IcebergProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.KafkaProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.KuduProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.MySQLProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.OracleProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.PostgreSQLProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.RedisProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.SQLServerProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.StarRocksProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.TDSQLPostgreSQLProvider;

public class LoadNodeProviderFactory {
    private static final List<LoadNodeProvider> LOAD_NODE_PROVIDER_LIST = new ArrayList<LoadNodeProvider>();

    public static LoadNodeProvider getLoadNodeProvider(String sinkType) {
        return LOAD_NODE_PROVIDER_LIST.stream().filter(inst -> inst.accept(sinkType)).findFirst().orElseThrow(() -> new BusinessException(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT, String.format(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT.getMessage(), sinkType)));
    }

    static {
        LOAD_NODE_PROVIDER_LIST.add(new KafkaProvider());
        LOAD_NODE_PROVIDER_LIST.add(new ClickHouseProvider());
        LOAD_NODE_PROVIDER_LIST.add(new DorisProvider());
        LOAD_NODE_PROVIDER_LIST.add(new ElasticsearchProvider());
        LOAD_NODE_PROVIDER_LIST.add(new GreenplumProvider());
        LOAD_NODE_PROVIDER_LIST.add(new HBaseProvider());
        LOAD_NODE_PROVIDER_LIST.add(new HDFSProvider());
        LOAD_NODE_PROVIDER_LIST.add(new HiveProvider());
        LOAD_NODE_PROVIDER_LIST.add(new HudiProvider());
        LOAD_NODE_PROVIDER_LIST.add(new IcebergProvider());
        LOAD_NODE_PROVIDER_LIST.add(new KuduProvider());
        LOAD_NODE_PROVIDER_LIST.add(new MySQLProvider());
        LOAD_NODE_PROVIDER_LIST.add(new OracleProvider());
        LOAD_NODE_PROVIDER_LIST.add(new PostgreSQLProvider());
        LOAD_NODE_PROVIDER_LIST.add(new RedisProvider());
        LOAD_NODE_PROVIDER_LIST.add(new SQLServerProvider());
        LOAD_NODE_PROVIDER_LIST.add(new StarRocksProvider());
        LOAD_NODE_PROVIDER_LIST.add(new TDSQLPostgreSQLProvider());
    }
}

