/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.es.ElasticsearchSink;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.node.load.ElasticsearchLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;

public class ElasticsearchProvider
implements LoadNodeProvider {
    @Override
    public Boolean accept(String sinkType) {
        return "ES".equals(sinkType);
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        ElasticsearchSink elasticsearchSink = (ElasticsearchSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(elasticsearchSink.getProperties());
        List<SinkField> sinkFieldList = elasticsearchSink.getSinkFieldList();
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(sinkFieldList, elasticsearchSink.getSinkName());
        List<FieldRelation> fieldRelations = this.parseSinkFields(sinkFieldList, constantFieldMap);
        Format format = this.parsingSinkMultipleFormat(elasticsearchSink.getSinkMultipleEnable(), elasticsearchSink.getSinkMultipleFormat());
        return new ElasticsearchLoadNode(elasticsearchSink.getSinkName(), elasticsearchSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, elasticsearchSink.getIndexName(), elasticsearchSink.getHosts(), elasticsearchSink.getUsername(), elasticsearchSink.getPassword(), elasticsearchSink.getDocumentType(), elasticsearchSink.getPrimaryKey(), elasticsearchSink.getEsVersion().intValue(), elasticsearchSink.getSinkMultipleEnable(), format, elasticsearchSink.getIndexPattern());
    }
}

