/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.apache.inlong.manager.common.fieldtype.strategy.MongoDBFieldTypeStrategy;
import org.apache.inlong.manager.pojo.sort.node.base.ExtractNodeProvider;
import org.apache.inlong.manager.pojo.source.mongodb.MongoDBSource;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.extract.MongoExtractNode;

public class MongoDBProvider
implements ExtractNodeProvider {
    private static final FieldTypeMappingStrategy FIELD_TYPE_MAPPING_STRATEGY = new MongoDBFieldTypeStrategy();

    @Override
    public Boolean accept(String sourceType) {
        return "MONGODB".equals(sourceType);
    }

    @Override
    public ExtractNode createExtractNode(StreamNode streamNodeInfo) {
        MongoDBSource source = (MongoDBSource)streamNodeInfo;
        List<FieldInfo> fieldInfos = this.parseStreamFieldInfos(source.getFieldList(), source.getSourceName(), FIELD_TYPE_MAPPING_STRATEGY);
        Map<String, String> properties = this.parseProperties(source.getProperties());
        return new MongoExtractNode(source.getSourceName(), source.getSourceName(), fieldInfos, null, properties, source.getCollection(), source.getHosts(), source.getUsername(), source.getPassword(), source.getDatabase());
    }
}

