/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.util;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.manager.common.enums.FieldType;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.apache.inlong.manager.pojo.fieldformat.ArrayFormat;
import org.apache.inlong.manager.pojo.fieldformat.BinaryFormat;
import org.apache.inlong.manager.pojo.fieldformat.DecimalFormat;
import org.apache.inlong.manager.pojo.fieldformat.MapFormat;
import org.apache.inlong.manager.pojo.fieldformat.StructFormat;
import org.apache.inlong.manager.pojo.fieldformat.VarBinaryFormat;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sort.util.FieldFormatUtils;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.sort.formats.common.ArrayFormatInfo;
import org.apache.inlong.sort.formats.common.BinaryFormatInfo;
import org.apache.inlong.sort.formats.common.BooleanFormatInfo;
import org.apache.inlong.sort.formats.common.ByteFormatInfo;
import org.apache.inlong.sort.formats.common.DateFormatInfo;
import org.apache.inlong.sort.formats.common.DecimalFormatInfo;
import org.apache.inlong.sort.formats.common.DoubleFormatInfo;
import org.apache.inlong.sort.formats.common.FloatFormatInfo;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.IntFormatInfo;
import org.apache.inlong.sort.formats.common.LocalZonedTimestampFormatInfo;
import org.apache.inlong.sort.formats.common.LongFormatInfo;
import org.apache.inlong.sort.formats.common.MapFormatInfo;
import org.apache.inlong.sort.formats.common.RowFormatInfo;
import org.apache.inlong.sort.formats.common.ShortFormatInfo;
import org.apache.inlong.sort.formats.common.StringFormatInfo;
import org.apache.inlong.sort.formats.common.TimeFormatInfo;
import org.apache.inlong.sort.formats.common.TimestampFormatInfo;
import org.apache.inlong.sort.formats.common.VarBinaryFormatInfo;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.MetaFieldInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldInfoUtils {
    private static final Logger log = LoggerFactory.getLogger(FieldInfoUtils.class);

    public static FieldInfo parseSinkFieldInfo(SinkField sinkField, String nodeId, FieldTypeMappingStrategy fieldTypeMappingStrategy) {
        boolean isMetaField = sinkField.getIsMetaField() == 1;
        String fieldType = sinkField.getFieldType();
        if (Objects.nonNull(fieldTypeMappingStrategy)) {
            fieldType = fieldTypeMappingStrategy.getFieldTypeMapping(fieldType);
        }
        FieldInfo fieldInfo = FieldInfoUtils.getFieldInfo(sinkField.getFieldName(), fieldType, isMetaField, sinkField.getMetaFieldName(), sinkField.getFieldFormat());
        fieldInfo.setNodeId(nodeId);
        return fieldInfo;
    }

    public static FieldInfo parseStreamFieldInfo(StreamField streamField, String nodeId, FieldTypeMappingStrategy fieldTypeMappingStrategy) {
        boolean isMetaField = streamField.getIsMetaField() == 1;
        String fieldType = streamField.getFieldType();
        if (Objects.nonNull(fieldTypeMappingStrategy)) {
            fieldType = fieldTypeMappingStrategy.getFieldTypeMapping(fieldType);
        }
        FieldInfo fieldInfo = FieldInfoUtils.getFieldInfo(streamField.getFieldName(), fieldType, isMetaField, streamField.getMetaFieldName(), streamField.getFieldFormat());
        fieldInfo.setNodeId(nodeId);
        return fieldInfo;
    }

    public static FieldInfo parseStreamField(StreamField streamField) {
        return FieldInfoUtils.parseStreamField(streamField, null);
    }

    public static FieldInfo parseStreamField(StreamField streamField, FieldTypeMappingStrategy fieldTypeMappingStrategy) {
        boolean isMetaField = streamField.getIsMetaField() == 1;
        String fieldType = streamField.getFieldType();
        if (Objects.nonNull(fieldTypeMappingStrategy)) {
            fieldType = fieldTypeMappingStrategy.getFieldTypeMapping(fieldType);
        }
        FieldInfo fieldInfo = FieldInfoUtils.getFieldInfo(streamField.getFieldName(), fieldType, isMetaField, streamField.getMetaFieldName(), streamField.getFieldFormat());
        fieldInfo.setNodeId(streamField.getOriginNodeName());
        return fieldInfo;
    }

    private static FieldInfo getFieldInfo(String fieldName, String fieldType, boolean isMetaField, String metaFieldName, String format) {
        if (isMetaField) {
            return new MetaFieldInfo(fieldName, MetaField.forName((String)metaFieldName));
        }
        return new FieldInfo(fieldName, FieldInfoUtils.convertFieldFormat(fieldType, format));
    }

    public static FormatInfo convertFieldFormat(String type) {
        FormatInfo formatInfo;
        FieldType fieldType = FieldType.forName((String)type);
        switch (fieldType) {
            case ARRAY: {
                formatInfo = new ArrayFormatInfo((FormatInfo)new StringFormatInfo());
                break;
            }
            case MAP: {
                formatInfo = new MapFormatInfo((FormatInfo)new StringFormatInfo(), (FormatInfo)new StringFormatInfo());
                break;
            }
            case STRUCT: {
                formatInfo = new RowFormatInfo(new String[0], new FormatInfo[0]);
                break;
            }
            default: {
                formatInfo = FieldInfoUtils.convertFieldFormat(type, null);
            }
        }
        return formatInfo;
    }

    public static Class<?> sqlTypeToJavaType(String type) {
        FieldType fieldType = FieldType.forName((String)StringUtils.substringBefore((String)type, (String)"("));
        switch (fieldType) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: {
                return Integer.TYPE;
            }
            case BIGINT: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case VARCHAR: 
            case STRING: {
                return String.class;
            }
            case DATE: 
            case TIME: {
                return Date.class;
            }
            case TIMESTAMP: 
            case TIMESTAMPTZ: {
                return Timestamp.class;
            }
        }
        return Object.class;
    }

    public static String sqlTypeToJavaTypeStr(String type) {
        Class<?> clazz = FieldInfoUtils.sqlTypeToJavaType(type);
        return clazz == Object.class ? "string" : clazz.getSimpleName().toLowerCase();
    }

    public static FormatInfo convertFieldFormat(String type, String format) {
        ArrayFormatInfo formatInfo;
        FieldType fieldType = FieldType.forName((String)StringUtils.substringBefore((String)type, (String)"("));
        switch (fieldType) {
            case BOOLEAN: {
                formatInfo = new BooleanFormatInfo();
                break;
            }
            case TINYINT: 
            case INT8: 
            case BYTE: {
                formatInfo = new ByteFormatInfo();
                break;
            }
            case SMALLINT: 
            case INT16: 
            case SHORT: {
                formatInfo = new ShortFormatInfo();
                break;
            }
            case INT: 
            case INT32: {
                formatInfo = new IntFormatInfo();
                break;
            }
            case BIGINT: 
            case INT64: 
            case LONG: {
                formatInfo = new LongFormatInfo();
                break;
            }
            case FLOAT: 
            case FLOAT32: {
                formatInfo = new FloatFormatInfo();
                break;
            }
            case DOUBLE: 
            case FLOAT64: {
                formatInfo = new DoubleFormatInfo();
                break;
            }
            case DECIMAL: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    DecimalFormat decimalFormat = FieldFormatUtils.parseDecimalFormat(format);
                    formatInfo = new DecimalFormatInfo(decimalFormat.getPrecision(), decimalFormat.getScale());
                    break;
                }
                formatInfo = new DecimalFormatInfo();
                break;
            }
            case DATE: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    formatInfo = new DateFormatInfo(FieldInfoUtils.convertTimestampOrDataFormat(format));
                    break;
                }
                formatInfo = new DateFormatInfo();
                break;
            }
            case TIME: 
            case DATETIME: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    formatInfo = new TimeFormatInfo(FieldInfoUtils.convertTimestampOrDataFormat(format));
                    break;
                }
                formatInfo = new TimeFormatInfo();
                break;
            }
            case TIMESTAMP: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    formatInfo = new TimestampFormatInfo(FieldInfoUtils.convertTimestampOrDataFormat(format));
                    break;
                }
                formatInfo = new TimestampFormatInfo();
                break;
            }
            case LOCAL_ZONE_TIMESTAMP: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    formatInfo = new LocalZonedTimestampFormatInfo(FieldInfoUtils.convertTimestampOrDataFormat(format), 2);
                    break;
                }
                formatInfo = new LocalZonedTimestampFormatInfo();
                break;
            }
            case BINARY: 
            case FIXED: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    BinaryFormat binaryFormat = FieldFormatUtils.parseBinaryFormat(format);
                    formatInfo = new BinaryFormatInfo(binaryFormat.getLength().intValue());
                    break;
                }
                formatInfo = new BinaryFormatInfo();
                break;
            }
            case VARBINARY: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    VarBinaryFormat varBinaryFormat = FieldFormatUtils.parseVarBinaryFormat(format);
                    formatInfo = new VarBinaryFormatInfo(varBinaryFormat.getLength().intValue());
                    break;
                }
                formatInfo = new VarBinaryFormatInfo();
                break;
            }
            case ARRAY: {
                formatInfo = FieldInfoUtils.createArrayFormatInfo(format);
                break;
            }
            case MAP: {
                formatInfo = FieldInfoUtils.createMapFormatInfo(format);
                break;
            }
            case STRUCT: {
                formatInfo = FieldInfoUtils.createRowFormatInfo(format);
                break;
            }
            default: {
                formatInfo = new StringFormatInfo();
            }
        }
        return formatInfo;
    }

    private static ArrayFormatInfo createArrayFormatInfo(String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            throw new IllegalArgumentException("Unsupported array type without format");
        }
        ArrayFormat arrayFormat = FieldFormatUtils.parseArrayFormat(format);
        FormatInfo elementFormatInfo = FieldInfoUtils.convertFieldFormat(arrayFormat.getElementType().name(), arrayFormat.getElementFormat());
        return new ArrayFormatInfo(elementFormatInfo);
    }

    private static MapFormatInfo createMapFormatInfo(String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            throw new IllegalArgumentException("Unsupported map type without format");
        }
        MapFormat mapFormat = FieldFormatUtils.parseMapFormat(format);
        FormatInfo keyFormatInfo = FieldInfoUtils.convertFieldFormat(mapFormat.getKeyType().name(), mapFormat.getKeyFormat());
        FormatInfo valueFormatInfo = FieldInfoUtils.convertFieldFormat(mapFormat.getValueType().name(), mapFormat.getValueFormat());
        return new MapFormatInfo(keyFormatInfo, valueFormatInfo);
    }

    private static RowFormatInfo createRowFormatInfo(String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            throw new IllegalArgumentException("Unsupported struct type without format");
        }
        StructFormat structFormat = FieldFormatUtils.parseStructFormat(format);
        ArrayList fieldNames = Lists.newArrayList();
        ArrayList formatInfos = Lists.newArrayList();
        for (StructFormat.Element element : structFormat.getElements()) {
            fieldNames.add(element.getFieldName());
            formatInfos.add(FieldInfoUtils.convertFieldFormat(element.getFieldType().name(), element.getFieldFormat()));
        }
        return new RowFormatInfo(fieldNames.toArray(new String[0]), formatInfos.toArray(new FormatInfo[0]));
    }

    private static String convertTimestampOrDataFormat(String format) {
        String sortFormat = format;
        switch (format) {
            case "MICROSECONDS": {
                sortFormat = "MICROS";
                break;
            }
            case "MILLISECONDS": {
                sortFormat = "MILLIS";
                break;
            }
            case "SECONDS": {
                sortFormat = "SECONDS";
                break;
            }
        }
        return sortFormat;
    }

    public static boolean compareFields(List<FieldInfo> sourceFields, List<FieldInfo> targetFields) {
        if (sourceFields.size() != targetFields.size()) {
            return false;
        }
        for (int i = 0; i < sourceFields.size(); ++i) {
            if (Objects.equals(sourceFields.get(i).getName(), targetFields.get(i).getName())) continue;
            return false;
        }
        return true;
    }
}

