/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.es;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.es.ElasticsearchSinkRequest;

public class ElasticsearchSinkDTO {
    @ApiModelProperty(value="indexNamePattern")
    private String indexNamePattern;
    @ApiModelProperty(value="contentOffset")
    private Integer contentOffset = 0;
    @ApiModelProperty(value="fieldOffset")
    private Integer fieldOffset;
    @ApiModelProperty(value="separator")
    private String separator;

    public static ElasticsearchSinkDTO getFromRequest(ElasticsearchSinkRequest request, String extParams) {
        ElasticsearchSinkDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? ElasticsearchSinkDTO.getFromJson(extParams) : new ElasticsearchSinkDTO();
        return (ElasticsearchSinkDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static ElasticsearchSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return (ElasticsearchSinkDTO)JsonUtils.parseObject((String)extParams, ElasticsearchSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of Elasticsearch SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static ElasticsearchSinkDTOBuilder builder() {
        return new ElasticsearchSinkDTOBuilder();
    }

    public String getIndexNamePattern() {
        return this.indexNamePattern;
    }

    public Integer getContentOffset() {
        return this.contentOffset;
    }

    public Integer getFieldOffset() {
        return this.fieldOffset;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setIndexNamePattern(String indexNamePattern) {
        this.indexNamePattern = indexNamePattern;
    }

    public void setContentOffset(Integer contentOffset) {
        this.contentOffset = contentOffset;
    }

    public void setFieldOffset(Integer fieldOffset) {
        this.fieldOffset = fieldOffset;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticsearchSinkDTO)) {
            return false;
        }
        ElasticsearchSinkDTO other = (ElasticsearchSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$contentOffset = this.getContentOffset();
        Integer other$contentOffset = other.getContentOffset();
        if (this$contentOffset == null ? other$contentOffset != null : !((Object)this$contentOffset).equals(other$contentOffset)) {
            return false;
        }
        Integer this$fieldOffset = this.getFieldOffset();
        Integer other$fieldOffset = other.getFieldOffset();
        if (this$fieldOffset == null ? other$fieldOffset != null : !((Object)this$fieldOffset).equals(other$fieldOffset)) {
            return false;
        }
        String this$indexNamePattern = this.getIndexNamePattern();
        String other$indexNamePattern = other.getIndexNamePattern();
        if (this$indexNamePattern == null ? other$indexNamePattern != null : !this$indexNamePattern.equals(other$indexNamePattern)) {
            return false;
        }
        String this$separator = this.getSeparator();
        String other$separator = other.getSeparator();
        return !(this$separator == null ? other$separator != null : !this$separator.equals(other$separator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticsearchSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $contentOffset = this.getContentOffset();
        result = result * 59 + ($contentOffset == null ? 43 : ((Object)$contentOffset).hashCode());
        Integer $fieldOffset = this.getFieldOffset();
        result = result * 59 + ($fieldOffset == null ? 43 : ((Object)$fieldOffset).hashCode());
        String $indexNamePattern = this.getIndexNamePattern();
        result = result * 59 + ($indexNamePattern == null ? 43 : $indexNamePattern.hashCode());
        String $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : $separator.hashCode());
        return result;
    }

    public String toString() {
        return "ElasticsearchSinkDTO(indexNamePattern=" + this.getIndexNamePattern() + ", contentOffset=" + this.getContentOffset() + ", fieldOffset=" + this.getFieldOffset() + ", separator=" + this.getSeparator() + ")";
    }

    public ElasticsearchSinkDTO() {
    }

    public ElasticsearchSinkDTO(String indexNamePattern, Integer contentOffset, Integer fieldOffset, String separator) {
        this.indexNamePattern = indexNamePattern;
        this.contentOffset = contentOffset;
        this.fieldOffset = fieldOffset;
        this.separator = separator;
    }

    public static class ElasticsearchSinkDTOBuilder {
        private String indexNamePattern;
        private Integer contentOffset;
        private Integer fieldOffset;
        private String separator;

        ElasticsearchSinkDTOBuilder() {
        }

        public ElasticsearchSinkDTOBuilder indexNamePattern(String indexNamePattern) {
            this.indexNamePattern = indexNamePattern;
            return this;
        }

        public ElasticsearchSinkDTOBuilder contentOffset(Integer contentOffset) {
            this.contentOffset = contentOffset;
            return this;
        }

        public ElasticsearchSinkDTOBuilder fieldOffset(Integer fieldOffset) {
            this.fieldOffset = fieldOffset;
            return this;
        }

        public ElasticsearchSinkDTOBuilder separator(String separator) {
            this.separator = separator;
            return this;
        }

        public ElasticsearchSinkDTO build() {
            return new ElasticsearchSinkDTO(this.indexNamePattern, this.contentOffset, this.fieldOffset, this.separator);
        }

        public String toString() {
            return "ElasticsearchSinkDTO.ElasticsearchSinkDTOBuilder(indexNamePattern=" + this.indexNamePattern + ", contentOffset=" + this.contentOffset + ", fieldOffset=" + this.fieldOffset + ", separator=" + this.separator + ")";
        }
    }
}

