/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.hive;

import io.swagger.annotations.ApiModelProperty;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.AESUtils;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.hive.HiveColumnInfo;
import org.apache.inlong.manager.pojo.sink.hive.HivePartitionField;
import org.apache.inlong.manager.pojo.sink.hive.HiveSinkRequest;
import org.apache.inlong.manager.pojo.sink.hive.HiveTableInfo;

public class HiveSinkDTO {
    @ApiModelProperty(value="Hive JDBC URL, such as jdbc:hive2://${ip}:${port}")
    private String jdbcUrl;
    @ApiModelProperty(value="Username of the Hive server")
    private String username;
    @ApiModelProperty(value="User password of the Hive server")
    private String password;
    @ApiModelProperty(value="Target database name")
    private String dbName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Data path, such as: hdfs://ip:port/user/hive/warehouse/test.db")
    private String dataPath;
    @ApiModelProperty(value="Partition interval, support: 1 H, 1 D, 30 I, 10 I")
    private Integer partitionInterval;
    @ApiModelProperty(value="Partition field list")
    private List<HivePartitionField> partitionFieldList;
    @ApiModelProperty(value="Partition creation strategy, partition start, partition close")
    private String partitionCreationStrategy;
    @ApiModelProperty(value="File format, support: TextFile, ORCFile, RCFile, SequenceFile, Avro, Parquet, etc")
    private String fileFormat;
    @ApiModelProperty(value="Data encoding format: UTF-8, GBK")
    private String dataEncoding;
    @ApiModelProperty(value="Data separator")
    private String dataSeparator;
    @ApiModelProperty(value="Properties for hive")
    private Map<String, Object> properties;
    @ApiModelProperty(value="Version for Hive, such as: 3.2.1")
    private String hiveVersion;
    @ApiModelProperty(value="Password encrypt version")
    private Integer encryptVersion;
    @ApiModelProperty(value="Config directory of Hive on HDFS, needed by sort in light mode, must include hive-site.xml")
    private String hiveConfDir;

    public static HiveSinkDTO getFromRequest(HiveSinkRequest request, String extParams) throws Exception {
        Integer encryptVersion = AESUtils.getCurrentVersion(null);
        String passwd = null;
        if (StringUtils.isNotEmpty((CharSequence)request.getPassword())) {
            passwd = AESUtils.encryptToString((byte[])request.getPassword().getBytes(StandardCharsets.UTF_8), (Integer)encryptVersion);
        }
        HiveSinkDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? HiveSinkDTO.getFromJson(extParams) : new HiveSinkDTO();
        CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
        dto.setPassword(passwd);
        dto.setEncryptVersion(encryptVersion);
        return dto;
    }

    public static HiveSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return ((HiveSinkDTO)JsonUtils.parseObject((String)extParams, HiveSinkDTO.class)).decryptPassword();
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of Hive SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static HiveTableInfo getHiveTableInfo(HiveSinkDTO hiveInfo, List<HiveColumnInfo> columnList) {
        HiveTableInfo tableInfo = new HiveTableInfo();
        tableInfo.setDbName(hiveInfo.getDbName());
        tableInfo.setTableName(hiveInfo.getTableName());
        if (CollectionUtils.isNotEmpty(hiveInfo.getPartitionFieldList())) {
            for (HivePartitionField field : hiveInfo.getPartitionFieldList()) {
                HiveColumnInfo columnInfo = new HiveColumnInfo();
                columnInfo.setName(field.getFieldName());
                columnInfo.setPartition(true);
                columnInfo.setType("string");
                columnList.add(columnInfo);
            }
        }
        tableInfo.setColumns(columnList);
        if (hiveInfo.getDataSeparator() != null) {
            char ch = (char)Integer.parseInt(hiveInfo.getDataSeparator());
            tableInfo.setFieldTerSymbol(String.valueOf(ch));
        }
        return tableInfo;
    }

    private HiveSinkDTO decryptPassword() throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.password)) {
            byte[] passwordBytes = AESUtils.decryptAsString((String)this.password, (Integer)this.encryptVersion);
            this.password = new String(passwordBytes, StandardCharsets.UTF_8);
        }
        return this;
    }

    public static HiveSinkDTOBuilder builder() {
        return new HiveSinkDTOBuilder();
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public Integer getPartitionInterval() {
        return this.partitionInterval;
    }

    public List<HivePartitionField> getPartitionFieldList() {
        return this.partitionFieldList;
    }

    public String getPartitionCreationStrategy() {
        return this.partitionCreationStrategy;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getDataEncoding() {
        return this.dataEncoding;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getHiveVersion() {
        return this.hiveVersion;
    }

    public Integer getEncryptVersion() {
        return this.encryptVersion;
    }

    public String getHiveConfDir() {
        return this.hiveConfDir;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setPartitionInterval(Integer partitionInterval) {
        this.partitionInterval = partitionInterval;
    }

    public void setPartitionFieldList(List<HivePartitionField> partitionFieldList) {
        this.partitionFieldList = partitionFieldList;
    }

    public void setPartitionCreationStrategy(String partitionCreationStrategy) {
        this.partitionCreationStrategy = partitionCreationStrategy;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setHiveVersion(String hiveVersion) {
        this.hiveVersion = hiveVersion;
    }

    public void setEncryptVersion(Integer encryptVersion) {
        this.encryptVersion = encryptVersion;
    }

    public void setHiveConfDir(String hiveConfDir) {
        this.hiveConfDir = hiveConfDir;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HiveSinkDTO)) {
            return false;
        }
        HiveSinkDTO other = (HiveSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$partitionInterval = this.getPartitionInterval();
        Integer other$partitionInterval = other.getPartitionInterval();
        if (this$partitionInterval == null ? other$partitionInterval != null : !((Object)this$partitionInterval).equals(other$partitionInterval)) {
            return false;
        }
        Integer this$encryptVersion = this.getEncryptVersion();
        Integer other$encryptVersion = other.getEncryptVersion();
        if (this$encryptVersion == null ? other$encryptVersion != null : !((Object)this$encryptVersion).equals(other$encryptVersion)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$dataPath = this.getDataPath();
        String other$dataPath = other.getDataPath();
        if (this$dataPath == null ? other$dataPath != null : !this$dataPath.equals(other$dataPath)) {
            return false;
        }
        List<HivePartitionField> this$partitionFieldList = this.getPartitionFieldList();
        List<HivePartitionField> other$partitionFieldList = other.getPartitionFieldList();
        if (this$partitionFieldList == null ? other$partitionFieldList != null : !((Object)this$partitionFieldList).equals(other$partitionFieldList)) {
            return false;
        }
        String this$partitionCreationStrategy = this.getPartitionCreationStrategy();
        String other$partitionCreationStrategy = other.getPartitionCreationStrategy();
        if (this$partitionCreationStrategy == null ? other$partitionCreationStrategy != null : !this$partitionCreationStrategy.equals(other$partitionCreationStrategy)) {
            return false;
        }
        String this$fileFormat = this.getFileFormat();
        String other$fileFormat = other.getFileFormat();
        if (this$fileFormat == null ? other$fileFormat != null : !this$fileFormat.equals(other$fileFormat)) {
            return false;
        }
        String this$dataEncoding = this.getDataEncoding();
        String other$dataEncoding = other.getDataEncoding();
        if (this$dataEncoding == null ? other$dataEncoding != null : !this$dataEncoding.equals(other$dataEncoding)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$hiveVersion = this.getHiveVersion();
        String other$hiveVersion = other.getHiveVersion();
        if (this$hiveVersion == null ? other$hiveVersion != null : !this$hiveVersion.equals(other$hiveVersion)) {
            return false;
        }
        String this$hiveConfDir = this.getHiveConfDir();
        String other$hiveConfDir = other.getHiveConfDir();
        return !(this$hiveConfDir == null ? other$hiveConfDir != null : !this$hiveConfDir.equals(other$hiveConfDir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HiveSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $partitionInterval = this.getPartitionInterval();
        result = result * 59 + ($partitionInterval == null ? 43 : ((Object)$partitionInterval).hashCode());
        Integer $encryptVersion = this.getEncryptVersion();
        result = result * 59 + ($encryptVersion == null ? 43 : ((Object)$encryptVersion).hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : $dataPath.hashCode());
        List<HivePartitionField> $partitionFieldList = this.getPartitionFieldList();
        result = result * 59 + ($partitionFieldList == null ? 43 : ((Object)$partitionFieldList).hashCode());
        String $partitionCreationStrategy = this.getPartitionCreationStrategy();
        result = result * 59 + ($partitionCreationStrategy == null ? 43 : $partitionCreationStrategy.hashCode());
        String $fileFormat = this.getFileFormat();
        result = result * 59 + ($fileFormat == null ? 43 : $fileFormat.hashCode());
        String $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : $dataEncoding.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $hiveVersion = this.getHiveVersion();
        result = result * 59 + ($hiveVersion == null ? 43 : $hiveVersion.hashCode());
        String $hiveConfDir = this.getHiveConfDir();
        result = result * 59 + ($hiveConfDir == null ? 43 : $hiveConfDir.hashCode());
        return result;
    }

    public String toString() {
        return "HiveSinkDTO(jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", dataPath=" + this.getDataPath() + ", partitionInterval=" + this.getPartitionInterval() + ", partitionFieldList=" + this.getPartitionFieldList() + ", partitionCreationStrategy=" + this.getPartitionCreationStrategy() + ", fileFormat=" + this.getFileFormat() + ", dataEncoding=" + this.getDataEncoding() + ", dataSeparator=" + this.getDataSeparator() + ", properties=" + this.getProperties() + ", hiveVersion=" + this.getHiveVersion() + ", encryptVersion=" + this.getEncryptVersion() + ", hiveConfDir=" + this.getHiveConfDir() + ")";
    }

    public HiveSinkDTO() {
    }

    public HiveSinkDTO(String jdbcUrl, String username, String password, String dbName, String tableName, String dataPath, Integer partitionInterval, List<HivePartitionField> partitionFieldList, String partitionCreationStrategy, String fileFormat, String dataEncoding, String dataSeparator, Map<String, Object> properties, String hiveVersion, Integer encryptVersion, String hiveConfDir) {
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.dbName = dbName;
        this.tableName = tableName;
        this.dataPath = dataPath;
        this.partitionInterval = partitionInterval;
        this.partitionFieldList = partitionFieldList;
        this.partitionCreationStrategy = partitionCreationStrategy;
        this.fileFormat = fileFormat;
        this.dataEncoding = dataEncoding;
        this.dataSeparator = dataSeparator;
        this.properties = properties;
        this.hiveVersion = hiveVersion;
        this.encryptVersion = encryptVersion;
        this.hiveConfDir = hiveConfDir;
    }

    public static class HiveSinkDTOBuilder {
        private String jdbcUrl;
        private String username;
        private String password;
        private String dbName;
        private String tableName;
        private String dataPath;
        private Integer partitionInterval;
        private List<HivePartitionField> partitionFieldList;
        private String partitionCreationStrategy;
        private String fileFormat;
        private String dataEncoding;
        private String dataSeparator;
        private Map<String, Object> properties;
        private String hiveVersion;
        private Integer encryptVersion;
        private String hiveConfDir;

        HiveSinkDTOBuilder() {
        }

        public HiveSinkDTOBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public HiveSinkDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public HiveSinkDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public HiveSinkDTOBuilder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public HiveSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public HiveSinkDTOBuilder dataPath(String dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        public HiveSinkDTOBuilder partitionInterval(Integer partitionInterval) {
            this.partitionInterval = partitionInterval;
            return this;
        }

        public HiveSinkDTOBuilder partitionFieldList(List<HivePartitionField> partitionFieldList) {
            this.partitionFieldList = partitionFieldList;
            return this;
        }

        public HiveSinkDTOBuilder partitionCreationStrategy(String partitionCreationStrategy) {
            this.partitionCreationStrategy = partitionCreationStrategy;
            return this;
        }

        public HiveSinkDTOBuilder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        public HiveSinkDTOBuilder dataEncoding(String dataEncoding) {
            this.dataEncoding = dataEncoding;
            return this;
        }

        public HiveSinkDTOBuilder dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return this;
        }

        public HiveSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public HiveSinkDTOBuilder hiveVersion(String hiveVersion) {
            this.hiveVersion = hiveVersion;
            return this;
        }

        public HiveSinkDTOBuilder encryptVersion(Integer encryptVersion) {
            this.encryptVersion = encryptVersion;
            return this;
        }

        public HiveSinkDTOBuilder hiveConfDir(String hiveConfDir) {
            this.hiveConfDir = hiveConfDir;
            return this;
        }

        public HiveSinkDTO build() {
            return new HiveSinkDTO(this.jdbcUrl, this.username, this.password, this.dbName, this.tableName, this.dataPath, this.partitionInterval, this.partitionFieldList, this.partitionCreationStrategy, this.fileFormat, this.dataEncoding, this.dataSeparator, this.properties, this.hiveVersion, this.encryptVersion, this.hiveConfDir);
        }

        public String toString() {
            return "HiveSinkDTO.HiveSinkDTOBuilder(jdbcUrl=" + this.jdbcUrl + ", username=" + this.username + ", password=" + this.password + ", dbName=" + this.dbName + ", tableName=" + this.tableName + ", dataPath=" + this.dataPath + ", partitionInterval=" + this.partitionInterval + ", partitionFieldList=" + this.partitionFieldList + ", partitionCreationStrategy=" + this.partitionCreationStrategy + ", fileFormat=" + this.fileFormat + ", dataEncoding=" + this.dataEncoding + ", dataSeparator=" + this.dataSeparator + ", properties=" + this.properties + ", hiveVersion=" + this.hiveVersion + ", encryptVersion=" + this.encryptVersion + ", hiveConfDir=" + this.hiveConfDir + ")";
        }
    }
}

