/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.pulsar;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.pulsar.PulsarSinkRequest;

public class PulsarSinkDTO {
    @ApiModelProperty(value="Pulsar tenant")
    private String pulsarTenant;
    @ApiModelProperty(value="Pulsar namespace")
    private String namespace;
    @ApiModelProperty(value="Pulsar topic")
    private String topic;
    @ApiModelProperty(value="Pulsar partition number")
    private Integer partitionNum;

    public static PulsarSinkDTO getFromRequest(PulsarSinkRequest request, String extParams) {
        PulsarSinkDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? PulsarSinkDTO.getFromJson(extParams) : new PulsarSinkDTO();
        return (PulsarSinkDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static PulsarSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return (PulsarSinkDTO)JsonUtils.parseObject((String)extParams, PulsarSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of pulsar SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static PulsarSinkDTOBuilder builder() {
        return new PulsarSinkDTOBuilder();
    }

    public String getPulsarTenant() {
        return this.pulsarTenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTopic() {
        return this.topic;
    }

    public Integer getPartitionNum() {
        return this.partitionNum;
    }

    public void setPulsarTenant(String pulsarTenant) {
        this.pulsarTenant = pulsarTenant;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setPartitionNum(Integer partitionNum) {
        this.partitionNum = partitionNum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarSinkDTO)) {
            return false;
        }
        PulsarSinkDTO other = (PulsarSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$partitionNum = this.getPartitionNum();
        Integer other$partitionNum = other.getPartitionNum();
        if (this$partitionNum == null ? other$partitionNum != null : !((Object)this$partitionNum).equals(other$partitionNum)) {
            return false;
        }
        String this$pulsarTenant = this.getPulsarTenant();
        String other$pulsarTenant = other.getPulsarTenant();
        if (this$pulsarTenant == null ? other$pulsarTenant != null : !this$pulsarTenant.equals(other$pulsarTenant)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        return !(this$topic == null ? other$topic != null : !this$topic.equals(other$topic));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PulsarSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $partitionNum = this.getPartitionNum();
        result = result * 59 + ($partitionNum == null ? 43 : ((Object)$partitionNum).hashCode());
        String $pulsarTenant = this.getPulsarTenant();
        result = result * 59 + ($pulsarTenant == null ? 43 : $pulsarTenant.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        return result;
    }

    public String toString() {
        return "PulsarSinkDTO(pulsarTenant=" + this.getPulsarTenant() + ", namespace=" + this.getNamespace() + ", topic=" + this.getTopic() + ", partitionNum=" + this.getPartitionNum() + ")";
    }

    public PulsarSinkDTO() {
    }

    public PulsarSinkDTO(String pulsarTenant, String namespace, String topic, Integer partitionNum) {
        this.pulsarTenant = pulsarTenant;
        this.namespace = namespace;
        this.topic = topic;
        this.partitionNum = partitionNum;
    }

    public static class PulsarSinkDTOBuilder {
        private String pulsarTenant;
        private String namespace;
        private String topic;
        private Integer partitionNum;

        PulsarSinkDTOBuilder() {
        }

        public PulsarSinkDTOBuilder pulsarTenant(String pulsarTenant) {
            this.pulsarTenant = pulsarTenant;
            return this;
        }

        public PulsarSinkDTOBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PulsarSinkDTOBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public PulsarSinkDTOBuilder partitionNum(Integer partitionNum) {
            this.partitionNum = partitionNum;
            return this;
        }

        public PulsarSinkDTO build() {
            return new PulsarSinkDTO(this.pulsarTenant, this.namespace, this.topic, this.partitionNum);
        }

        public String toString() {
            return "PulsarSinkDTO.PulsarSinkDTOBuilder(pulsarTenant=" + this.pulsarTenant + ", namespace=" + this.namespace + ", topic=" + this.topic + ", partitionNum=" + this.partitionNum + ")";
        }
    }
}

