/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.pojo.sink.hbase.HBaseSink;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.load.HbaseLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;

public class HBaseProvider
implements LoadNodeProvider {
    @Override
    public Boolean accept(String sinkType) {
        return "HBASE".equals(sinkType);
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        HBaseSink hbaseSink = (HBaseSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(hbaseSink.getProperties());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(hbaseSink.getSinkFieldList(), hbaseSink.getSinkName());
        List<FieldRelation> fieldRelations = this.parseSinkFields(hbaseSink.getSinkFieldList(), constantFieldMap);
        return new HbaseLoadNode(hbaseSink.getSinkName(), hbaseSink.getSinkName(), fieldInfos, fieldRelations, (List)Lists.newArrayList(), null, null, properties, hbaseSink.getTableName(), hbaseSink.getNamespace(), hbaseSink.getZkQuorum(), hbaseSink.getRowKey(), hbaseSink.getBufferFlushMaxSize(), hbaseSink.getZkNodeParent(), hbaseSink.getBufferFlushMaxRows(), hbaseSink.getBufferFlushInterval());
    }
}

