/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.pojo.sink.hudi.HudiSink;
import org.apache.inlong.manager.pojo.sort.node.base.ExtractNodeProvider;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.source.hudi.HudiSource;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.constant.HudiConstant;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.extract.HudiExtractNode;
import org.apache.inlong.sort.protocol.node.load.HudiLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;

public class HudiProvider
implements ExtractNodeProvider,
LoadNodeProvider {
    @Override
    public Boolean accept(String streamType) {
        return "HUDI".equals(streamType);
    }

    @Override
    public ExtractNode createExtractNode(StreamNode streamNodeInfo) {
        HudiSource source = (HudiSource)streamNodeInfo;
        List<FieldInfo> fieldInfos = this.parseStreamFieldInfos(source.getFieldList(), source.getSourceName());
        Map<String, String> properties = this.parseProperties(source.getProperties());
        return new HudiExtractNode(source.getSourceName(), source.getSourceName(), fieldInfos, null, source.getCatalogUri(), source.getWarehouse(), source.getDbName(), source.getTableName(), HudiConstant.CatalogType.HIVE, source.getCheckIntervalInMinus(), source.isReadStreamingSkipCompaction(), source.getReadStartCommit(), properties, source.getExtList());
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        HudiSink hudiSink = (HudiSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(hudiSink.getProperties());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(hudiSink.getSinkFieldList(), hudiSink.getSinkName());
        List<FieldRelation> fieldRelations = this.parseSinkFields(hudiSink.getSinkFieldList(), constantFieldMap);
        HudiConstant.CatalogType catalogType = HudiConstant.CatalogType.forName((String)hudiSink.getCatalogType());
        return new HudiLoadNode(hudiSink.getSinkName(), hudiSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, hudiSink.getDbName(), hudiSink.getTableName(), hudiSink.getPrimaryKey(), catalogType, hudiSink.getCatalogUri(), hudiSink.getWarehouse(), hudiSink.getExtList(), hudiSink.getPartitionKey());
    }
}

