/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.apache.inlong.manager.common.fieldtype.strategy.PostgreSQLFieldTypeStrategy;
import org.apache.inlong.manager.pojo.sink.postgresql.PostgreSQLSink;
import org.apache.inlong.manager.pojo.sort.node.base.ExtractNodeProvider;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.source.postgresql.PostgreSQLSource;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.extract.PostgresExtractNode;
import org.apache.inlong.sort.protocol.node.load.PostgresLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;

public class PostgreSQLProvider
implements ExtractNodeProvider,
LoadNodeProvider {
    private static final FieldTypeMappingStrategy FIELD_TYPE_MAPPING_STRATEGY = new PostgreSQLFieldTypeStrategy();

    @Override
    public Boolean accept(String streamType) {
        return "POSTGRESQL".equals(streamType);
    }

    @Override
    public ExtractNode createExtractNode(StreamNode streamNodeInfo) {
        PostgreSQLSource postgreSQLSource = (PostgreSQLSource)streamNodeInfo;
        List<FieldInfo> fieldInfos = this.parseStreamFieldInfos(postgreSQLSource.getFieldList(), postgreSQLSource.getSourceName(), FIELD_TYPE_MAPPING_STRATEGY);
        Map<String, String> properties = this.parseProperties(postgreSQLSource.getProperties());
        return new PostgresExtractNode(postgreSQLSource.getSourceName(), postgreSQLSource.getSourceName(), fieldInfos, null, properties, postgreSQLSource.getPrimaryKey(), postgreSQLSource.getTableNameList(), postgreSQLSource.getHostname(), postgreSQLSource.getUsername(), postgreSQLSource.getPassword(), postgreSQLSource.getDatabase(), postgreSQLSource.getSchema(), postgreSQLSource.getPort(), postgreSQLSource.getDecodingPluginName(), postgreSQLSource.getServerTimeZone(), postgreSQLSource.getScanStartupMode());
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        PostgreSQLSink postgreSQLSink = (PostgreSQLSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(postgreSQLSink.getProperties());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(postgreSQLSink.getSinkFieldList(), postgreSQLSink.getSinkName(), FIELD_TYPE_MAPPING_STRATEGY);
        List<FieldRelation> fieldRelations = this.parseSinkFields(postgreSQLSink.getSinkFieldList(), constantFieldMap);
        return new PostgresLoadNode(postgreSQLSink.getSinkName(), postgreSQLSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, postgreSQLSink.getJdbcUrl(), postgreSQLSink.getUsername(), postgreSQLSink.getPassword(), postgreSQLSink.getDbName() + "." + postgreSQLSink.getTableName(), postgreSQLSink.getPrimaryKey());
    }
}

