/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.standalone;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SortSourceClusterInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortSourceClusterInfo.class);
    private static final Gson GSON = new Gson();
    private static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((String)"&").trimResults().withKeyValueSeparator("=");
    private static final String KEY_IS_CONSUMABLE = "consumer";
    private static final long serialVersionUID = 1L;
    String name;
    String type;
    String url;
    String clusterTags;
    String extTag;
    String extParams;
    Set<String> clusterTagsSet;
    Map<String, String> extTagMap = new ConcurrentHashMap<String, String>();
    Map<String, String> extParamsMap = new ConcurrentHashMap<String, String>();

    public Set<String> getClusterTagsSet() {
        if (CollectionUtils.isEmpty(this.clusterTagsSet) && StringUtils.isNotBlank((CharSequence)this.clusterTags)) {
            this.clusterTagsSet = ImmutableSet.copyOf((Object[])this.clusterTags.split(","));
        }
        return this.clusterTagsSet;
    }

    public Map<String, String> getExtParamsMap() {
        if (this.extParamsMap.isEmpty() && this.extParams != null) {
            try {
                JsonObject jo = (JsonObject)GSON.fromJson(this.extParams, JsonObject.class);
                this.extParamsMap = new HashMap<String, String>();
                jo.keySet().forEach(k -> {
                    JsonElement element = jo.get(k);
                    if (element.isJsonPrimitive()) {
                        this.extParamsMap.put((String)k, element.getAsString());
                    } else {
                        this.extParamsMap.put((String)k, element.toString());
                    }
                });
            }
            catch (Throwable t) {
                LOGGER.error("fail to parse cluster ext params", t);
            }
        }
        return this.extParamsMap;
    }

    public Map<String, String> getExtTagMap() {
        if (this.extTagMap.isEmpty() && StringUtils.isNotBlank((CharSequence)this.extTag)) {
            try {
                this.extTagMap = MAP_SPLITTER.split((CharSequence)this.extTag);
            }
            catch (Throwable t) {
                LOGGER.error("fail to parse cluster ext tag params", t);
            }
        }
        return this.extTagMap;
    }

    public boolean isConsumable() {
        String isConsumable = this.getExtTagMap().get(KEY_IS_CONSUMABLE);
        return isConsumable == null || "true".equalsIgnoreCase(isConsumable);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SortSourceClusterInfo)) {
            return false;
        }
        SortSourceClusterInfo other = (SortSourceClusterInfo)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.clusterTags, other.clusterTags) && Objects.equals(this.type, other.type) && Objects.equals(this.extParams, other.extParams) && Objects.equals(this.extTag, other.extTag);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getClusterTags() {
        return this.clusterTags;
    }

    public String getExtTag() {
        return this.extTag;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setClusterTags(String clusterTags) {
        this.clusterTags = clusterTags;
    }

    public void setExtTag(String extTag) {
        this.extTag = extTag;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public void setClusterTagsSet(Set<String> clusterTagsSet) {
        this.clusterTagsSet = clusterTagsSet;
    }

    public void setExtTagMap(Map<String, String> extTagMap) {
        this.extTagMap = extTagMap;
    }

    public void setExtParamsMap(Map<String, String> extParamsMap) {
        this.extParamsMap = extParamsMap;
    }

    public String toString() {
        return "SortSourceClusterInfo(name=" + this.getName() + ", type=" + this.getType() + ", url=" + this.getUrl() + ", clusterTags=" + this.getClusterTags() + ", extTag=" + this.getExtTag() + ", extParams=" + this.getExtParams() + ", clusterTagsSet=" + this.getClusterTagsSet() + ", extTagMap=" + this.getExtTagMap() + ", extParamsMap=" + this.getExtParamsMap() + ")";
    }
}

