/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.manager.common.enums.TransformType;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.sort.util.StreamParseUtils;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.transform.TransformDefinition;
import org.apache.inlong.manager.pojo.transform.TransformResponse;
import org.apache.inlong.manager.pojo.transform.filter.FilterDefinition;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.transformation.ConstantParam;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.LogicOperator;
import org.apache.inlong.sort.protocol.transformation.SingleValueCompareOperator;
import org.apache.inlong.sort.protocol.transformation.function.SingleValueFilterFunction;
import org.apache.inlong.sort.protocol.transformation.operator.AndOperator;
import org.apache.inlong.sort.protocol.transformation.operator.EmptyOperator;
import org.apache.inlong.sort.protocol.transformation.operator.EqualOperator;
import org.apache.inlong.sort.protocol.transformation.operator.IsNotNullOperator;
import org.apache.inlong.sort.protocol.transformation.operator.IsNullOperator;
import org.apache.inlong.sort.protocol.transformation.operator.LessThanOperator;
import org.apache.inlong.sort.protocol.transformation.operator.LessThanOrEqualOperator;
import org.apache.inlong.sort.protocol.transformation.operator.MoreThanOperator;
import org.apache.inlong.sort.protocol.transformation.operator.MoreThanOrEqualOperator;
import org.apache.inlong.sort.protocol.transformation.operator.NotEqualOperator;
import org.apache.inlong.sort.protocol.transformation.operator.OrOperator;

public class FilterFunctionUtils {
    public static List<FilterFunction> createFilterFunctions(TransformResponse transformResponse) {
        TransformType transformType = TransformType.forType((String)transformResponse.getTransformType());
        TransformDefinition transformDefinition = StreamParseUtils.parseTransformDefinition(transformResponse.getTransformDefinition(), transformType);
        String transformName = transformResponse.getTransformName();
        switch (transformType) {
            case FILTER: {
                FilterDefinition filterDefinition = (FilterDefinition)transformDefinition;
                return FilterFunctionUtils.createFilterFunctions(filterDefinition, transformName);
            }
            case DE_DUPLICATION: 
            case SPLITTER: 
            case JOINER: 
            case LOOKUP_JOINER: 
            case TEMPORAL_JOINER: 
            case INTERVAL_JOINER: 
            case STRING_REPLACER: 
            case ENCRYPT: {
                return Lists.newArrayList();
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported transformType=%s", transformType));
    }

    public static List<FilterFunction> createFilterFunctions(FilterDefinition filterDefinition, String transformName) {
        FilterDefinition.FilterMode filterMode = filterDefinition.getFilterMode();
        Preconditions.expectFalse((filterMode == FilterDefinition.FilterMode.SCRIPT ? 1 : 0) != 0, (String)String.format("Unsupported filterMode=%s for inlong", new Object[]{filterMode}));
        List<FilterDefinition.FilterRule> filterRules = filterDefinition.getFilterRules();
        List<FilterFunction> filterFunctions = filterRules.stream().map(filterRule -> FilterFunctionUtils.createFilterFunction(filterRule, transformName)).collect(Collectors.toList());
        for (int index = filterFunctions.size() - 1; index > 0; --index) {
            SingleValueFilterFunction function = (SingleValueFilterFunction)filterFunctions.get(index);
            SingleValueFilterFunction preFunction = (SingleValueFilterFunction)filterFunctions.get(index - 1);
            function.setLogicOperator(preFunction.getLogicOperator());
        }
        ((SingleValueFilterFunction)filterFunctions.get(0)).setLogicOperator((LogicOperator)EmptyOperator.getInstance());
        return filterFunctions;
    }

    public static FilterStrategy parseFilterStrategy(TransformResponse transformResponse) {
        TransformType transformType = TransformType.forType((String)transformResponse.getTransformType());
        TransformDefinition transformDefinition = StreamParseUtils.parseTransformDefinition(transformResponse.getTransformDefinition(), transformType);
        switch (transformType) {
            case FILTER: {
                FilterDefinition filterDefinition = (FilterDefinition)transformDefinition;
                switch (filterDefinition.getFilterStrategy()) {
                    case REMOVE: {
                        return FilterStrategy.REMOVE;
                    }
                    case RETAIN: {
                        return FilterStrategy.RETAIN;
                    }
                }
                return FilterStrategy.RETAIN;
            }
            case DE_DUPLICATION: 
            case SPLITTER: 
            case JOINER: 
            case LOOKUP_JOINER: 
            case TEMPORAL_JOINER: 
            case INTERVAL_JOINER: 
            case STRING_REPLACER: 
            case ENCRYPT: {
                return null;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported transformType=%s", transformType));
    }

    private static FilterFunction createFilterFunction(FilterDefinition.FilterRule filterRule, String transformName) {
        StreamField streamField = filterRule.getSourceField();
        String fieldType = streamField.getFieldType();
        String fieldFormat = streamField.getFieldFormat();
        String fieldName = streamField.getFieldName();
        FieldInfo sourceFieldInfo = new FieldInfo(fieldName, transformName, FieldInfoUtils.convertFieldFormat(fieldType, fieldFormat));
        TransformDefinition.OperationType operationType = filterRule.getOperationType();
        SingleValueCompareOperator compareOperator = FilterFunctionUtils.parseCompareOperator(operationType);
        FilterDefinition.TargetValue targetValue = filterRule.getTargetValue();
        FunctionParam target = FilterFunctionUtils.parseTargetValue(targetValue, transformName);
        TransformDefinition.RuleRelation relationWithPost = filterRule.getRelationWithPost();
        LogicOperator logicOperator = FilterFunctionUtils.parseLogicOperator(relationWithPost);
        return new SingleValueFilterFunction(logicOperator, (FunctionParam)sourceFieldInfo, compareOperator, target);
    }

    private static LogicOperator parseLogicOperator(TransformDefinition.RuleRelation relation) {
        if (relation == null) {
            return EmptyOperator.getInstance();
        }
        switch (relation) {
            case OR: {
                return OrOperator.getInstance();
            }
            case AND: {
                return AndOperator.getInstance();
            }
        }
        return EmptyOperator.getInstance();
    }

    private static FunctionParam parseTargetValue(FilterDefinition.TargetValue value, String transformName) {
        if (value == null) {
            return new ConstantParam((Object)"");
        }
        boolean isConstant = value.isConstant();
        if (isConstant) {
            String constant = value.getTargetConstant();
            return new ConstantParam((Object)constant);
        }
        StreamField targetField = value.getTargetField();
        String fieldType = targetField.getFieldType();
        String fieldFormat = targetField.getFieldFormat();
        String fieldName = targetField.getFieldName();
        return new FieldInfo(fieldName, transformName, FieldInfoUtils.convertFieldFormat(fieldType, fieldFormat));
    }

    private static SingleValueCompareOperator parseCompareOperator(TransformDefinition.OperationType operationType) {
        switch (operationType) {
            case eq: {
                return EqualOperator.getInstance();
            }
            case ge: {
                return MoreThanOrEqualOperator.getInstance();
            }
            case gt: {
                return MoreThanOperator.getInstance();
            }
            case le: {
                return LessThanOrEqualOperator.getInstance();
            }
            case lt: {
                return LessThanOperator.getInstance();
            }
            case ne: {
                return NotEqualOperator.getInstance();
            }
            case is_null: {
                return IsNullOperator.getInstance();
            }
            case not_null: {
                return IsNotNullOperator.getInstance();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported operateType=%s", new Object[]{operationType}));
    }
}

