/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.file;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.file.FileSourceRequest;

@ApiModel(value="File source info")
@JsonTypeDefine(value="FILE")
public class FileSource
extends StreamSource {
    @ApiModelProperty(value="Path regex pattern for file, such as /a/b/*.txt")
    private String pattern;
    @ApiModelProperty(value="Path blacklist for file, which will be filtered and not collect")
    private String blackList;
    @ApiModelProperty(value="TimeOffset for collection, '1m' means from one minute after, '-1m' means from one minute before, '1h' means from one hour after, '-1h' means from one minute before, '1d' means from one day after, '-1d' means from one minute before, Null or blank means from current timestamp")
    private String timeOffset;
    @ApiModelProperty(value="Line end regex pattern, for example: &end&")
    private String lineEndPattern;
    @ApiModelProperty(value="Type of file content, for example: FULL, INCREMENT")
    private String contentCollectType;
    @ApiModelProperty(value="File needs to collect environment information, for example: kubernetes")
    private String envList;
    @ApiModelProperty(value="Metadata of data, for example: [{data:field1,field2},{kubernetes:namespace,labels,name,uuid}] and so on")
    private List<Map<String, String>> metaFields;
    @ApiModelProperty(value=" Type of data result for column separator         CSV format, set this parameter to a custom separator: , | :          Json format, set this parameter to json ")
    private String dataContentStyle;
    @ApiModelProperty(value="Cycle unit")
    private String cycleUnit;
    @ApiModelProperty(value="Max file count")
    private String maxFileCount;
    @ApiModelProperty(value="Time zone")
    private String timeZone;
    @ApiModelProperty(value="Whether retry")
    private Boolean retry;
    @ApiModelProperty(value="Start time")
    private Long startTime;
    @ApiModelProperty(value="End time")
    private Long endTime;
    @ApiModelProperty(value="Metadata filters by label, special parameters for K8S")
    private Map<String, String> filterMetaByLabels;

    public FileSource() {
        this.setSourceType("FILE");
    }

    @Override
    public SourceRequest genSourceRequest() {
        return (SourceRequest)CommonBeanUtils.copyProperties((Object)this, FileSourceRequest::new);
    }

    protected FileSource(FileSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.pattern = ((FileSourceBuilder)b).pattern;
        this.blackList = ((FileSourceBuilder)b).blackList;
        this.timeOffset = ((FileSourceBuilder)b).timeOffset;
        this.lineEndPattern = ((FileSourceBuilder)b).lineEndPattern;
        this.contentCollectType = ((FileSourceBuilder)b).contentCollectType;
        this.envList = ((FileSourceBuilder)b).envList;
        this.metaFields = ((FileSourceBuilder)b).metaFields;
        this.dataContentStyle = ((FileSourceBuilder)b).dataContentStyle;
        this.cycleUnit = ((FileSourceBuilder)b).cycleUnit;
        this.maxFileCount = ((FileSourceBuilder)b).maxFileCount;
        this.timeZone = ((FileSourceBuilder)b).timeZone;
        this.retry = ((FileSourceBuilder)b).retry;
        this.startTime = ((FileSourceBuilder)b).startTime;
        this.endTime = ((FileSourceBuilder)b).endTime;
        this.filterMetaByLabels = ((FileSourceBuilder)b).filterMetaByLabels;
    }

    public static FileSourceBuilder<?, ?> builder() {
        return new FileSourceBuilderImpl();
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getBlackList() {
        return this.blackList;
    }

    public String getTimeOffset() {
        return this.timeOffset;
    }

    public String getLineEndPattern() {
        return this.lineEndPattern;
    }

    public String getContentCollectType() {
        return this.contentCollectType;
    }

    public String getEnvList() {
        return this.envList;
    }

    public List<Map<String, String>> getMetaFields() {
        return this.metaFields;
    }

    public String getDataContentStyle() {
        return this.dataContentStyle;
    }

    public String getCycleUnit() {
        return this.cycleUnit;
    }

    public String getMaxFileCount() {
        return this.maxFileCount;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public Boolean getRetry() {
        return this.retry;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Map<String, String> getFilterMetaByLabels() {
        return this.filterMetaByLabels;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setBlackList(String blackList) {
        this.blackList = blackList;
    }

    public void setTimeOffset(String timeOffset) {
        this.timeOffset = timeOffset;
    }

    public void setLineEndPattern(String lineEndPattern) {
        this.lineEndPattern = lineEndPattern;
    }

    public void setContentCollectType(String contentCollectType) {
        this.contentCollectType = contentCollectType;
    }

    public void setEnvList(String envList) {
        this.envList = envList;
    }

    public void setMetaFields(List<Map<String, String>> metaFields) {
        this.metaFields = metaFields;
    }

    public void setDataContentStyle(String dataContentStyle) {
        this.dataContentStyle = dataContentStyle;
    }

    public void setCycleUnit(String cycleUnit) {
        this.cycleUnit = cycleUnit;
    }

    public void setMaxFileCount(String maxFileCount) {
        this.maxFileCount = maxFileCount;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setRetry(Boolean retry) {
        this.retry = retry;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public void setFilterMetaByLabels(Map<String, String> filterMetaByLabels) {
        this.filterMetaByLabels = filterMetaByLabels;
    }

    public FileSource(String pattern, String blackList, String timeOffset, String lineEndPattern, String contentCollectType, String envList, List<Map<String, String>> metaFields, String dataContentStyle, String cycleUnit, String maxFileCount, String timeZone, Boolean retry, Long startTime, Long endTime, Map<String, String> filterMetaByLabels) {
        this.pattern = pattern;
        this.blackList = blackList;
        this.timeOffset = timeOffset;
        this.lineEndPattern = lineEndPattern;
        this.contentCollectType = contentCollectType;
        this.envList = envList;
        this.metaFields = metaFields;
        this.dataContentStyle = dataContentStyle;
        this.cycleUnit = cycleUnit;
        this.maxFileCount = maxFileCount;
        this.timeZone = timeZone;
        this.retry = retry;
        this.startTime = startTime;
        this.endTime = endTime;
        this.filterMetaByLabels = filterMetaByLabels;
    }

    @Override
    public String toString() {
        return "FileSource(super=" + super.toString() + ", pattern=" + this.getPattern() + ", blackList=" + this.getBlackList() + ", timeOffset=" + this.getTimeOffset() + ", lineEndPattern=" + this.getLineEndPattern() + ", contentCollectType=" + this.getContentCollectType() + ", envList=" + this.getEnvList() + ", metaFields=" + this.getMetaFields() + ", dataContentStyle=" + this.getDataContentStyle() + ", cycleUnit=" + this.getCycleUnit() + ", maxFileCount=" + this.getMaxFileCount() + ", timeZone=" + this.getTimeZone() + ", retry=" + this.getRetry() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", filterMetaByLabels=" + this.getFilterMetaByLabels() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSource)) {
            return false;
        }
        FileSource other = (FileSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$retry = this.getRetry();
        Boolean other$retry = other.getRetry();
        if (this$retry == null ? other$retry != null : !((Object)this$retry).equals(other$retry)) {
            return false;
        }
        Long this$startTime = this.getStartTime();
        Long other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Long this$endTime = this.getEndTime();
        Long other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$blackList = this.getBlackList();
        String other$blackList = other.getBlackList();
        if (this$blackList == null ? other$blackList != null : !this$blackList.equals(other$blackList)) {
            return false;
        }
        String this$timeOffset = this.getTimeOffset();
        String other$timeOffset = other.getTimeOffset();
        if (this$timeOffset == null ? other$timeOffset != null : !this$timeOffset.equals(other$timeOffset)) {
            return false;
        }
        String this$lineEndPattern = this.getLineEndPattern();
        String other$lineEndPattern = other.getLineEndPattern();
        if (this$lineEndPattern == null ? other$lineEndPattern != null : !this$lineEndPattern.equals(other$lineEndPattern)) {
            return false;
        }
        String this$contentCollectType = this.getContentCollectType();
        String other$contentCollectType = other.getContentCollectType();
        if (this$contentCollectType == null ? other$contentCollectType != null : !this$contentCollectType.equals(other$contentCollectType)) {
            return false;
        }
        String this$envList = this.getEnvList();
        String other$envList = other.getEnvList();
        if (this$envList == null ? other$envList != null : !this$envList.equals(other$envList)) {
            return false;
        }
        List<Map<String, String>> this$metaFields = this.getMetaFields();
        List<Map<String, String>> other$metaFields = other.getMetaFields();
        if (this$metaFields == null ? other$metaFields != null : !((Object)this$metaFields).equals(other$metaFields)) {
            return false;
        }
        String this$dataContentStyle = this.getDataContentStyle();
        String other$dataContentStyle = other.getDataContentStyle();
        if (this$dataContentStyle == null ? other$dataContentStyle != null : !this$dataContentStyle.equals(other$dataContentStyle)) {
            return false;
        }
        String this$cycleUnit = this.getCycleUnit();
        String other$cycleUnit = other.getCycleUnit();
        if (this$cycleUnit == null ? other$cycleUnit != null : !this$cycleUnit.equals(other$cycleUnit)) {
            return false;
        }
        String this$maxFileCount = this.getMaxFileCount();
        String other$maxFileCount = other.getMaxFileCount();
        if (this$maxFileCount == null ? other$maxFileCount != null : !this$maxFileCount.equals(other$maxFileCount)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        Map<String, String> this$filterMetaByLabels = this.getFilterMetaByLabels();
        Map<String, String> other$filterMetaByLabels = other.getFilterMetaByLabels();
        return !(this$filterMetaByLabels == null ? other$filterMetaByLabels != null : !((Object)this$filterMetaByLabels).equals(other$filterMetaByLabels));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FileSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $retry = this.getRetry();
        result = result * 59 + ($retry == null ? 43 : ((Object)$retry).hashCode());
        Long $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Long $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $blackList = this.getBlackList();
        result = result * 59 + ($blackList == null ? 43 : $blackList.hashCode());
        String $timeOffset = this.getTimeOffset();
        result = result * 59 + ($timeOffset == null ? 43 : $timeOffset.hashCode());
        String $lineEndPattern = this.getLineEndPattern();
        result = result * 59 + ($lineEndPattern == null ? 43 : $lineEndPattern.hashCode());
        String $contentCollectType = this.getContentCollectType();
        result = result * 59 + ($contentCollectType == null ? 43 : $contentCollectType.hashCode());
        String $envList = this.getEnvList();
        result = result * 59 + ($envList == null ? 43 : $envList.hashCode());
        List<Map<String, String>> $metaFields = this.getMetaFields();
        result = result * 59 + ($metaFields == null ? 43 : ((Object)$metaFields).hashCode());
        String $dataContentStyle = this.getDataContentStyle();
        result = result * 59 + ($dataContentStyle == null ? 43 : $dataContentStyle.hashCode());
        String $cycleUnit = this.getCycleUnit();
        result = result * 59 + ($cycleUnit == null ? 43 : $cycleUnit.hashCode());
        String $maxFileCount = this.getMaxFileCount();
        result = result * 59 + ($maxFileCount == null ? 43 : $maxFileCount.hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        Map<String, String> $filterMetaByLabels = this.getFilterMetaByLabels();
        result = result * 59 + ($filterMetaByLabels == null ? 43 : ((Object)$filterMetaByLabels).hashCode());
        return result;
    }

    private static final class FileSourceBuilderImpl
    extends FileSourceBuilder<FileSource, FileSourceBuilderImpl> {
        private FileSourceBuilderImpl() {
        }

        @Override
        protected FileSourceBuilderImpl self() {
            return this;
        }

        @Override
        public FileSource build() {
            return new FileSource(this);
        }
    }

    public static abstract class FileSourceBuilder<C extends FileSource, B extends FileSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private String pattern;
        private String blackList;
        private String timeOffset;
        private String lineEndPattern;
        private String contentCollectType;
        private String envList;
        private List<Map<String, String>> metaFields;
        private String dataContentStyle;
        private String cycleUnit;
        private String maxFileCount;
        private String timeZone;
        private Boolean retry;
        private Long startTime;
        private Long endTime;
        private Map<String, String> filterMetaByLabels;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B pattern(String pattern) {
            this.pattern = pattern;
            return (B)this.self();
        }

        public B blackList(String blackList) {
            this.blackList = blackList;
            return (B)this.self();
        }

        public B timeOffset(String timeOffset) {
            this.timeOffset = timeOffset;
            return (B)this.self();
        }

        public B lineEndPattern(String lineEndPattern) {
            this.lineEndPattern = lineEndPattern;
            return (B)this.self();
        }

        public B contentCollectType(String contentCollectType) {
            this.contentCollectType = contentCollectType;
            return (B)this.self();
        }

        public B envList(String envList) {
            this.envList = envList;
            return (B)this.self();
        }

        public B metaFields(List<Map<String, String>> metaFields) {
            this.metaFields = metaFields;
            return (B)this.self();
        }

        public B dataContentStyle(String dataContentStyle) {
            this.dataContentStyle = dataContentStyle;
            return (B)this.self();
        }

        public B cycleUnit(String cycleUnit) {
            this.cycleUnit = cycleUnit;
            return (B)this.self();
        }

        public B maxFileCount(String maxFileCount) {
            this.maxFileCount = maxFileCount;
            return (B)this.self();
        }

        public B timeZone(String timeZone) {
            this.timeZone = timeZone;
            return (B)this.self();
        }

        public B retry(Boolean retry) {
            this.retry = retry;
            return (B)this.self();
        }

        public B startTime(Long startTime) {
            this.startTime = startTime;
            return (B)this.self();
        }

        public B endTime(Long endTime) {
            this.endTime = endTime;
            return (B)this.self();
        }

        public B filterMetaByLabels(Map<String, String> filterMetaByLabels) {
            this.filterMetaByLabels = filterMetaByLabels;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FileSource.FileSourceBuilder(super=" + super.toString() + ", pattern=" + this.pattern + ", blackList=" + this.blackList + ", timeOffset=" + this.timeOffset + ", lineEndPattern=" + this.lineEndPattern + ", contentCollectType=" + this.contentCollectType + ", envList=" + this.envList + ", metaFields=" + this.metaFields + ", dataContentStyle=" + this.dataContentStyle + ", cycleUnit=" + this.cycleUnit + ", maxFileCount=" + this.maxFileCount + ", timeZone=" + this.timeZone + ", retry=" + this.retry + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", filterMetaByLabels=" + this.filterMetaByLabels + ")";
        }
    }
}

