/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.mongodb;

import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.source.mongodb.MongoDBSourceRequest;

public class MongoDBSourceDTO {
    @ApiModelProperty(value="Hosts of the MongoDB server")
    private String hosts;
    @ApiModelProperty(value="Username of the MongoDB server")
    private String username;
    @ApiModelProperty(value="Password of the MongoDB server")
    private String password;
    @ApiModelProperty(value="MongoDB database name")
    private String database;
    @ApiModelProperty(value="MongoDB collection name")
    private String collection;
    @ApiModelProperty(value="Primary key must be shared by all tables")
    private String primaryKey;
    @ApiModelProperty(value="Properties for MongoDB")
    private Map<String, Object> properties;

    public static MongoDBSourceDTO getFromRequest(MongoDBSourceRequest request, String extParams) {
        MongoDBSourceDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? MongoDBSourceDTO.getFromJson(extParams) : new MongoDBSourceDTO();
        return (MongoDBSourceDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static MongoDBSourceDTO getFromJson(@NotNull String extParams) {
        try {
            return (MongoDBSourceDTO)JsonUtils.parseObject((String)extParams, MongoDBSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("parse extParams of MongoDBSource failure: %s", e.getMessage()));
        }
    }

    public static MongoDBSourceDTOBuilder builder() {
        return new MongoDBSourceDTOBuilder();
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongoDBSourceDTO)) {
            return false;
        }
        MongoDBSourceDTO other = (MongoDBSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$hosts = this.getHosts();
        String other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !this$hosts.equals(other$hosts)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MongoDBSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : $hosts.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "MongoDBSourceDTO(hosts=" + this.getHosts() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", collection=" + this.getCollection() + ", primaryKey=" + this.getPrimaryKey() + ", properties=" + this.getProperties() + ")";
    }

    public MongoDBSourceDTO(String hosts, String username, String password, String database, String collection, String primaryKey, Map<String, Object> properties) {
        this.hosts = hosts;
        this.username = username;
        this.password = password;
        this.database = database;
        this.collection = collection;
        this.primaryKey = primaryKey;
        this.properties = properties;
    }

    public MongoDBSourceDTO() {
    }

    public static class MongoDBSourceDTOBuilder {
        private String hosts;
        private String username;
        private String password;
        private String database;
        private String collection;
        private String primaryKey;
        private Map<String, Object> properties;

        MongoDBSourceDTOBuilder() {
        }

        public MongoDBSourceDTOBuilder hosts(String hosts) {
            this.hosts = hosts;
            return this;
        }

        public MongoDBSourceDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public MongoDBSourceDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public MongoDBSourceDTOBuilder database(String database) {
            this.database = database;
            return this;
        }

        public MongoDBSourceDTOBuilder collection(String collection) {
            this.collection = collection;
            return this;
        }

        public MongoDBSourceDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public MongoDBSourceDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public MongoDBSourceDTO build() {
            return new MongoDBSourceDTO(this.hosts, this.username, this.password, this.database, this.collection, this.primaryKey, this.properties);
        }

        public String toString() {
            return "MongoDBSourceDTO.MongoDBSourceDTOBuilder(hosts=" + this.hosts + ", username=" + this.username + ", password=" + this.password + ", database=" + this.database + ", collection=" + this.collection + ", primaryKey=" + this.primaryKey + ", properties=" + this.properties + ")";
        }
    }
}

