/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.stream;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.stream.BaseInlongStream;
import org.apache.inlong.manager.pojo.stream.InlongStreamExtInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamRequest;
import org.apache.inlong.manager.pojo.stream.StreamField;

@ApiModel(value="Inlong stream info")
public class InlongStreamInfo
extends BaseInlongStream {
    public static final int ENABLE_WRAP_WITH_INLONG_MSG = 1;
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @ApiModelProperty(value="Inlong group id")
    private String inlongGroupId;
    @ApiModelProperty(value="Inlong stream id")
    private String inlongStreamId;
    @ApiModelProperty(value="Inlong stream name", required=true)
    private String name;
    @ApiModelProperty(value="Inlong stream description")
    private String description;
    @ApiModelProperty(value="MQ resource for inlong stream. Default: ${inlongStreamId}", notes="in inlong stream, TubeMQ corresponds to filter consumption ID, Pulsar corresponds to Topic")
    private String mqResource;
    @ApiModelProperty(value="Data type, including: TEXT, KV, etc.")
    private String dataType;
    @ApiModelProperty(value="Data encoding format: UTF-8, GBK")
    private String dataEncoding;
    @ApiModelProperty(value="Data separator")
    private String dataSeparator;
    @ApiModelProperty(value="Data field escape symbol")
    private String dataEscapeChar;
    @ApiModelProperty(value="Whether to send synchronously, 0: no, 1: yes", notes="Each task under this stream sends data synchronously, which will affect the throughput of data collection, please choose carefully")
    private Integer syncSend;
    @ApiModelProperty(value="Number of access items per day, unit: 10,000 items per day")
    private Integer dailyRecords;
    @ApiModelProperty(value="Access size per day, unit: GB per day")
    private Integer dailyStorage;
    @ApiModelProperty(value="peak access per second, unit: bars per second")
    private Integer peakRecords;
    @ApiModelProperty(value="The maximum length of a single piece of data, unit: Byte")
    private Integer maxLength;
    @ApiModelProperty(value="Data storage period, unit: day")
    private Integer storagePeriod;
    @ApiModelProperty(value="Extended params, will be saved as JSON string")
    private String extParams;
    @ApiModelProperty(value="Status")
    private Integer status;
    @ApiModelProperty(value="Previous status")
    private Integer previousStatus;
    @ApiModelProperty(value="Name of creator")
    private String creator;
    @ApiModelProperty(value="Name of modifier")
    private String modifier;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
    private Date createTime;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
    private Date modifyTime;
    @ApiModelProperty(value="Field list")
    private List<StreamField> fieldList;
    @ApiModelProperty(value="Inlong stream Extension properties")
    private List<InlongStreamExtInfo> extList;
    @ApiModelProperty(value="Stream source infos")
    private List<StreamSource> sourceList = new ArrayList<StreamSource>();
    @ApiModelProperty(value="Stream sink infos")
    private List<StreamSink> sinkList = new ArrayList<StreamSink>();
    @ApiModelProperty(value="Version number")
    private Integer version;
    @ApiModelProperty(value="The message body wrap type, including: RAW, INLONG_MSG_V0, INLONG_MSG_V1, etc")
    private String wrapType;
    @ApiModelProperty(value="If use extended fields")
    private Boolean useExtendedFields = false;
    @ApiModelProperty(value="Extended field size")
    private Integer extendedFieldSize = 0;
    @ApiModelProperty(value="The multiple enable of sink")
    private Boolean sinkMultipleEnable;
    @ApiModelProperty(value="Whether to ignore the parse errors of field value")
    private Boolean ignoreParseError = true;

    public InlongStreamRequest genRequest() {
        return (InlongStreamRequest)CommonBeanUtils.copyProperties((Object)this, InlongStreamRequest::new);
    }

    public Integer getId() {
        return this.id;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMqResource() {
        return this.mqResource;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getDataEncoding() {
        return this.dataEncoding;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getDataEscapeChar() {
        return this.dataEscapeChar;
    }

    public Integer getSyncSend() {
        return this.syncSend;
    }

    public Integer getDailyRecords() {
        return this.dailyRecords;
    }

    public Integer getDailyStorage() {
        return this.dailyStorage;
    }

    public Integer getPeakRecords() {
        return this.peakRecords;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getStoragePeriod() {
        return this.storagePeriod;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getPreviousStatus() {
        return this.previousStatus;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public List<StreamField> getFieldList() {
        return this.fieldList;
    }

    public List<InlongStreamExtInfo> getExtList() {
        return this.extList;
    }

    public List<StreamSource> getSourceList() {
        return this.sourceList;
    }

    public List<StreamSink> getSinkList() {
        return this.sinkList;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getWrapType() {
        return this.wrapType;
    }

    public Boolean getUseExtendedFields() {
        return this.useExtendedFields;
    }

    public Integer getExtendedFieldSize() {
        return this.extendedFieldSize;
    }

    public Boolean getSinkMultipleEnable() {
        return this.sinkMultipleEnable;
    }

    public Boolean getIgnoreParseError() {
        return this.ignoreParseError;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMqResource(String mqResource) {
        this.mqResource = mqResource;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setDataEscapeChar(String dataEscapeChar) {
        this.dataEscapeChar = dataEscapeChar;
    }

    public void setSyncSend(Integer syncSend) {
        this.syncSend = syncSend;
    }

    public void setDailyRecords(Integer dailyRecords) {
        this.dailyRecords = dailyRecords;
    }

    public void setDailyStorage(Integer dailyStorage) {
        this.dailyStorage = dailyStorage;
    }

    public void setPeakRecords(Integer peakRecords) {
        this.peakRecords = peakRecords;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setStoragePeriod(Integer storagePeriod) {
        this.storagePeriod = storagePeriod;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setPreviousStatus(Integer previousStatus) {
        this.previousStatus = previousStatus;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone="GMT+8")
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setFieldList(List<StreamField> fieldList) {
        this.fieldList = fieldList;
    }

    public void setExtList(List<InlongStreamExtInfo> extList) {
        this.extList = extList;
    }

    public void setSourceList(List<StreamSource> sourceList) {
        this.sourceList = sourceList;
    }

    public void setSinkList(List<StreamSink> sinkList) {
        this.sinkList = sinkList;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setWrapType(String wrapType) {
        this.wrapType = wrapType;
    }

    public void setUseExtendedFields(Boolean useExtendedFields) {
        this.useExtendedFields = useExtendedFields;
    }

    public void setExtendedFieldSize(Integer extendedFieldSize) {
        this.extendedFieldSize = extendedFieldSize;
    }

    public void setSinkMultipleEnable(Boolean sinkMultipleEnable) {
        this.sinkMultipleEnable = sinkMultipleEnable;
    }

    public void setIgnoreParseError(Boolean ignoreParseError) {
        this.ignoreParseError = ignoreParseError;
    }

    @Override
    public String toString() {
        return "InlongStreamInfo(id=" + this.getId() + ", inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", mqResource=" + this.getMqResource() + ", dataType=" + this.getDataType() + ", dataEncoding=" + this.getDataEncoding() + ", dataSeparator=" + this.getDataSeparator() + ", dataEscapeChar=" + this.getDataEscapeChar() + ", syncSend=" + this.getSyncSend() + ", dailyRecords=" + this.getDailyRecords() + ", dailyStorage=" + this.getDailyStorage() + ", peakRecords=" + this.getPeakRecords() + ", maxLength=" + this.getMaxLength() + ", storagePeriod=" + this.getStoragePeriod() + ", extParams=" + this.getExtParams() + ", status=" + this.getStatus() + ", previousStatus=" + this.getPreviousStatus() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", fieldList=" + this.getFieldList() + ", extList=" + this.getExtList() + ", sourceList=" + this.getSourceList() + ", sinkList=" + this.getSinkList() + ", version=" + this.getVersion() + ", wrapType=" + this.getWrapType() + ", useExtendedFields=" + this.getUseExtendedFields() + ", extendedFieldSize=" + this.getExtendedFieldSize() + ", sinkMultipleEnable=" + this.getSinkMultipleEnable() + ", ignoreParseError=" + this.getIgnoreParseError() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongStreamInfo)) {
            return false;
        }
        InlongStreamInfo other = (InlongStreamInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$syncSend = this.getSyncSend();
        Integer other$syncSend = other.getSyncSend();
        if (this$syncSend == null ? other$syncSend != null : !((Object)this$syncSend).equals(other$syncSend)) {
            return false;
        }
        Integer this$dailyRecords = this.getDailyRecords();
        Integer other$dailyRecords = other.getDailyRecords();
        if (this$dailyRecords == null ? other$dailyRecords != null : !((Object)this$dailyRecords).equals(other$dailyRecords)) {
            return false;
        }
        Integer this$dailyStorage = this.getDailyStorage();
        Integer other$dailyStorage = other.getDailyStorage();
        if (this$dailyStorage == null ? other$dailyStorage != null : !((Object)this$dailyStorage).equals(other$dailyStorage)) {
            return false;
        }
        Integer this$peakRecords = this.getPeakRecords();
        Integer other$peakRecords = other.getPeakRecords();
        if (this$peakRecords == null ? other$peakRecords != null : !((Object)this$peakRecords).equals(other$peakRecords)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Integer this$storagePeriod = this.getStoragePeriod();
        Integer other$storagePeriod = other.getStoragePeriod();
        if (this$storagePeriod == null ? other$storagePeriod != null : !((Object)this$storagePeriod).equals(other$storagePeriod)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$previousStatus = this.getPreviousStatus();
        Integer other$previousStatus = other.getPreviousStatus();
        if (this$previousStatus == null ? other$previousStatus != null : !((Object)this$previousStatus).equals(other$previousStatus)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Boolean this$useExtendedFields = this.getUseExtendedFields();
        Boolean other$useExtendedFields = other.getUseExtendedFields();
        if (this$useExtendedFields == null ? other$useExtendedFields != null : !((Object)this$useExtendedFields).equals(other$useExtendedFields)) {
            return false;
        }
        Integer this$extendedFieldSize = this.getExtendedFieldSize();
        Integer other$extendedFieldSize = other.getExtendedFieldSize();
        if (this$extendedFieldSize == null ? other$extendedFieldSize != null : !((Object)this$extendedFieldSize).equals(other$extendedFieldSize)) {
            return false;
        }
        Boolean this$sinkMultipleEnable = this.getSinkMultipleEnable();
        Boolean other$sinkMultipleEnable = other.getSinkMultipleEnable();
        if (this$sinkMultipleEnable == null ? other$sinkMultipleEnable != null : !((Object)this$sinkMultipleEnable).equals(other$sinkMultipleEnable)) {
            return false;
        }
        Boolean this$ignoreParseError = this.getIgnoreParseError();
        Boolean other$ignoreParseError = other.getIgnoreParseError();
        if (this$ignoreParseError == null ? other$ignoreParseError != null : !((Object)this$ignoreParseError).equals(other$ignoreParseError)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$mqResource = this.getMqResource();
        String other$mqResource = other.getMqResource();
        if (this$mqResource == null ? other$mqResource != null : !this$mqResource.equals(other$mqResource)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$dataEncoding = this.getDataEncoding();
        String other$dataEncoding = other.getDataEncoding();
        if (this$dataEncoding == null ? other$dataEncoding != null : !this$dataEncoding.equals(other$dataEncoding)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$dataEscapeChar = this.getDataEscapeChar();
        String other$dataEscapeChar = other.getDataEscapeChar();
        if (this$dataEscapeChar == null ? other$dataEscapeChar != null : !this$dataEscapeChar.equals(other$dataEscapeChar)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        if (this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        if (this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime)) {
            return false;
        }
        List<StreamField> this$fieldList = this.getFieldList();
        List<StreamField> other$fieldList = other.getFieldList();
        if (this$fieldList == null ? other$fieldList != null : !((Object)this$fieldList).equals(other$fieldList)) {
            return false;
        }
        List<InlongStreamExtInfo> this$extList = this.getExtList();
        List<InlongStreamExtInfo> other$extList = other.getExtList();
        if (this$extList == null ? other$extList != null : !((Object)this$extList).equals(other$extList)) {
            return false;
        }
        List<StreamSource> this$sourceList = this.getSourceList();
        List<StreamSource> other$sourceList = other.getSourceList();
        if (this$sourceList == null ? other$sourceList != null : !((Object)this$sourceList).equals(other$sourceList)) {
            return false;
        }
        List<StreamSink> this$sinkList = this.getSinkList();
        List<StreamSink> other$sinkList = other.getSinkList();
        if (this$sinkList == null ? other$sinkList != null : !((Object)this$sinkList).equals(other$sinkList)) {
            return false;
        }
        String this$wrapType = this.getWrapType();
        String other$wrapType = other.getWrapType();
        return !(this$wrapType == null ? other$wrapType != null : !this$wrapType.equals(other$wrapType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InlongStreamInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $syncSend = this.getSyncSend();
        result = result * 59 + ($syncSend == null ? 43 : ((Object)$syncSend).hashCode());
        Integer $dailyRecords = this.getDailyRecords();
        result = result * 59 + ($dailyRecords == null ? 43 : ((Object)$dailyRecords).hashCode());
        Integer $dailyStorage = this.getDailyStorage();
        result = result * 59 + ($dailyStorage == null ? 43 : ((Object)$dailyStorage).hashCode());
        Integer $peakRecords = this.getPeakRecords();
        result = result * 59 + ($peakRecords == null ? 43 : ((Object)$peakRecords).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Integer $storagePeriod = this.getStoragePeriod();
        result = result * 59 + ($storagePeriod == null ? 43 : ((Object)$storagePeriod).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $previousStatus = this.getPreviousStatus();
        result = result * 59 + ($previousStatus == null ? 43 : ((Object)$previousStatus).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Boolean $useExtendedFields = this.getUseExtendedFields();
        result = result * 59 + ($useExtendedFields == null ? 43 : ((Object)$useExtendedFields).hashCode());
        Integer $extendedFieldSize = this.getExtendedFieldSize();
        result = result * 59 + ($extendedFieldSize == null ? 43 : ((Object)$extendedFieldSize).hashCode());
        Boolean $sinkMultipleEnable = this.getSinkMultipleEnable();
        result = result * 59 + ($sinkMultipleEnable == null ? 43 : ((Object)$sinkMultipleEnable).hashCode());
        Boolean $ignoreParseError = this.getIgnoreParseError();
        result = result * 59 + ($ignoreParseError == null ? 43 : ((Object)$ignoreParseError).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $mqResource = this.getMqResource();
        result = result * 59 + ($mqResource == null ? 43 : $mqResource.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : $dataEncoding.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $dataEscapeChar = this.getDataEscapeChar();
        result = result * 59 + ($dataEscapeChar == null ? 43 : $dataEscapeChar.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        List<StreamField> $fieldList = this.getFieldList();
        result = result * 59 + ($fieldList == null ? 43 : ((Object)$fieldList).hashCode());
        List<InlongStreamExtInfo> $extList = this.getExtList();
        result = result * 59 + ($extList == null ? 43 : ((Object)$extList).hashCode());
        List<StreamSource> $sourceList = this.getSourceList();
        result = result * 59 + ($sourceList == null ? 43 : ((Object)$sourceList).hashCode());
        List<StreamSink> $sinkList = this.getSinkList();
        result = result * 59 + ($sinkList == null ? 43 : ((Object)$sinkList).hashCode());
        String $wrapType = this.getWrapType();
        result = result * 59 + ($wrapType == null ? 43 : $wrapType.hashCode());
        return result;
    }

    public InlongStreamInfo() {
    }

    public InlongStreamInfo(Integer id, String inlongGroupId, String inlongStreamId, String name, String description, String mqResource, String dataType, String dataEncoding, String dataSeparator, String dataEscapeChar, Integer syncSend, Integer dailyRecords, Integer dailyStorage, Integer peakRecords, Integer maxLength, Integer storagePeriod, String extParams, Integer status, Integer previousStatus, String creator, String modifier, Date createTime, Date modifyTime, List<StreamField> fieldList, List<InlongStreamExtInfo> extList, List<StreamSource> sourceList, List<StreamSink> sinkList, Integer version, String wrapType, Boolean useExtendedFields, Integer extendedFieldSize, Boolean sinkMultipleEnable, Boolean ignoreParseError) {
        this.id = id;
        this.inlongGroupId = inlongGroupId;
        this.inlongStreamId = inlongStreamId;
        this.name = name;
        this.description = description;
        this.mqResource = mqResource;
        this.dataType = dataType;
        this.dataEncoding = dataEncoding;
        this.dataSeparator = dataSeparator;
        this.dataEscapeChar = dataEscapeChar;
        this.syncSend = syncSend;
        this.dailyRecords = dailyRecords;
        this.dailyStorage = dailyStorage;
        this.peakRecords = peakRecords;
        this.maxLength = maxLength;
        this.storagePeriod = storagePeriod;
        this.extParams = extParams;
        this.status = status;
        this.previousStatus = previousStatus;
        this.creator = creator;
        this.modifier = modifier;
        this.createTime = createTime;
        this.modifyTime = modifyTime;
        this.fieldList = fieldList;
        this.extList = extList;
        this.sourceList = sourceList;
        this.sinkList = sinkList;
        this.version = version;
        this.wrapType = wrapType;
        this.useExtendedFields = useExtendedFields;
        this.extendedFieldSize = extendedFieldSize;
        this.sinkMultipleEnable = sinkMultipleEnable;
        this.ignoreParseError = ignoreParseError;
    }
}

