/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.stream;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;

public class StreamNodeRelation {
    private Set<String> inputNodes;
    private Set<String> outputNodes;

    public StreamNodeRelation() {
        this(Sets.newHashSet(), Sets.newHashSet());
    }

    public StreamNodeRelation(Set<String> inputNodes, Set<String> outputNodes) {
        this.inputNodes = inputNodes;
        this.outputNodes = outputNodes;
    }

    public void addInputNode(String inputNode) {
        Preconditions.expectNotBlank((String)inputNode, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"Input node should not be empty");
        this.inputNodes.add(inputNode);
    }

    public void addOutputNode(String outputNode) {
        Preconditions.expectNotBlank((String)outputNode, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"Input node should not be empty");
        this.outputNodes.add(outputNode);
    }

    public Set<String> getInputNodes() {
        return this.inputNodes;
    }

    public Set<String> getOutputNodes() {
        return this.outputNodes;
    }

    public void setInputNodes(Set<String> inputNodes) {
        this.inputNodes = inputNodes;
    }

    public void setOutputNodes(Set<String> outputNodes) {
        this.outputNodes = outputNodes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamNodeRelation)) {
            return false;
        }
        StreamNodeRelation other = (StreamNodeRelation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$inputNodes = this.getInputNodes();
        Set<String> other$inputNodes = other.getInputNodes();
        if (this$inputNodes == null ? other$inputNodes != null : !((Object)this$inputNodes).equals(other$inputNodes)) {
            return false;
        }
        Set<String> this$outputNodes = this.getOutputNodes();
        Set<String> other$outputNodes = other.getOutputNodes();
        return !(this$outputNodes == null ? other$outputNodes != null : !((Object)this$outputNodes).equals(other$outputNodes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamNodeRelation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $inputNodes = this.getInputNodes();
        result = result * 59 + ($inputNodes == null ? 43 : ((Object)$inputNodes).hashCode());
        Set<String> $outputNodes = this.getOutputNodes();
        result = result * 59 + ($outputNodes == null ? 43 : ((Object)$outputNodes).hashCode());
        return result;
    }

    public String toString() {
        return "StreamNodeRelation(inputNodes=" + this.getInputNodes() + ", outputNodes=" + this.getOutputNodes() + ")";
    }
}

