/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.user.UserLoginRequest;
import org.apache.inlong.manager.pojo.user.UserRequest;
import org.apache.inlong.manager.service.user.LoginUserUtils;
import org.apache.inlong.manager.service.user.UserService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"User-Anno-API"})
public class AnnoController {
    private static final Logger log = LoggerFactory.getLogger(AnnoController.class);
    @Autowired
    private UserService userService;

    @PostMapping(value={"/anno/login"})
    public Response<Boolean> login(@Validated @RequestBody UserLoginRequest loginRequest) {
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(loginRequest.getUsername(), loginRequest.getPassword());
        subject.login((AuthenticationToken)token);
        LoginUserUtils.setUserLoginInfo((UserInfo)((UserInfo)subject.getPrincipal()));
        return Response.success((Object)true);
    }

    @PostMapping(value={"/anno/register"})
    public Response<Integer> register(@Validated @RequestBody UserRequest request) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.userService.save(request, currentUser));
    }

    @GetMapping(value={"/anno/logout"})
    public Response<Boolean> logout() {
        SecurityUtils.getSubject().logout();
        return Response.success((Object)true);
    }
}

