/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.common.UpdateResult;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodePageRequest;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.service.node.DataNodeService;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.apache.inlong.manager.service.user.LoginUserUtils;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"Data-Node-API"})
public class DataNodeController {
    @Autowired
    private DataNodeService dataNodeService;

    @PostMapping(value={"/node/save"})
    @ApiOperation(value="Save node")
    @OperationLog(operation=OperationType.CREATE)
    @RequiresRoles(value={"ADMIN"})
    public Response<Integer> save(@Validated @RequestBody DataNodeRequest request) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.dataNodeService.save(request, currentUser));
    }

    @GetMapping(value={"/node/get/{id}"})
    @ApiOperation(value="Get node by id")
    @ApiImplicitParam(name="id", value="Data node ID", dataTypeClass=Integer.class, required=true)
    public Response<DataNodeInfo> get(@PathVariable Integer id) {
        return Response.success((Object)this.dataNodeService.get(id));
    }

    @PostMapping(value={"/node/list"})
    @ApiOperation(value="List data node")
    public Response<PageResult<DataNodeInfo>> list(@RequestBody DataNodePageRequest request) {
        return Response.success((Object)this.dataNodeService.list(request));
    }

    @PostMapping(value={"/node/update"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Update data node")
    public Response<Boolean> update(@Validated(value={UpdateValidation.class}) @RequestBody DataNodeRequest request) {
        String username = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.dataNodeService.update(request, username));
    }

    @PostMapping(value={"/node/updateByKey"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Update data node by key")
    public Response<UpdateResult> updateByKey(@RequestBody DataNodeRequest request) {
        String username = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.dataNodeService.updateByKey(request, username));
    }

    @DeleteMapping(value={"/node/delete/{id}"})
    @ApiOperation(value="Delete data node by id")
    @OperationLog(operation=OperationType.DELETE)
    @ApiImplicitParam(name="id", value="Data node ID", dataTypeClass=Integer.class, required=true)
    @RequiresRoles(value={"ADMIN"})
    public Response<Boolean> delete(@PathVariable Integer id) {
        return Response.success((Object)this.dataNodeService.delete(id, LoginUserUtils.getLoginUser().getName()));
    }

    @DeleteMapping(value={"/node/deleteByKey"})
    @ApiOperation(value="Delete data node by key")
    @OperationLog(operation=OperationType.DELETE)
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="Data node name", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="type", value="Data node type", dataTypeClass=String.class, required=true)})
    @RequiresRoles(value={"ADMIN"})
    public Response<Boolean> deleteByKey(@RequestParam String name, @RequestParam String type) {
        return Response.success((Object)this.dataNodeService.deleteByKey(name, type, LoginUserUtils.getLoginUser().getName()));
    }

    @PostMapping(value={"/node/testConnection"})
    @ApiOperation(value="Test connection for data node")
    public Response<Boolean> testConnection(@Validated @RequestBody DataNodeRequest request) {
        return Response.success((Object)this.dataNodeService.testConnection(request));
    }
}

