/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.transform.DeleteTransformRequest;
import org.apache.inlong.manager.pojo.transform.TransformRequest;
import org.apache.inlong.manager.pojo.transform.TransformResponse;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.apache.inlong.manager.service.transform.StreamTransformService;
import org.apache.inlong.manager.service.user.LoginUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"Stream-Transform-API"})
public class StreamTransformController {
    @Autowired
    protected StreamTransformService streamTransformService;

    @RequestMapping(value={"/transform/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Save stream transform")
    public Response<Integer> save(@Validated @RequestBody TransformRequest request) {
        return Response.success((Object)this.streamTransformService.save(request, LoginUserUtils.getLoginUser().getName()));
    }

    @RequestMapping(value={"/transform/list"}, method={RequestMethod.GET})
    @ApiOperation(value="Get stream transform list")
    public Response<List<TransformResponse>> list(@RequestParam(value="inlongGroupId") String groupId, @RequestParam(value="inlongStreamId") String streamId) {
        return Response.success((Object)this.streamTransformService.listTransform(groupId, streamId));
    }

    @RequestMapping(value={"/transform/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Update stream transform")
    public Response<Boolean> update(@Validated(value={UpdateValidation.class}) @RequestBody TransformRequest request) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.streamTransformService.update(request, operator));
    }

    @RequestMapping(value={"/transform/delete"}, method={RequestMethod.DELETE})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Delete stream transform")
    public Response<Boolean> delete(@Validated DeleteTransformRequest request) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.streamTransformService.delete(request, operator));
    }
}

