/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.user.UserRequest;
import org.apache.inlong.manager.service.user.LoginUserUtils;
import org.apache.inlong.manager.service.user.UserService;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api"})
@Api(tags={"User-Auth-API"})
public class UserController {
    @Autowired
    UserService userService;

    @PostMapping(value={"/user/currentUser"})
    @ApiOperation(value="Get the logged-in user")
    public Response<UserInfo> currentUser() {
        return Response.success((Object)LoginUserUtils.getLoginUser());
    }

    @PostMapping(value={"/user/register"})
    @ApiOperation(value="Register user")
    @RequiresRoles(value={"ADMIN"})
    public Response<Integer> register(@Validated @RequestBody UserRequest userInfo) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.userService.save(userInfo, currentUser));
    }

    @GetMapping(value={"/user/get/{id}"})
    @ApiOperation(value="Get user info by user id")
    public Response<UserInfo> getById(@PathVariable Integer id) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.userService.getById(id, currentUser));
    }

    @GetMapping(value={"/user/getByName/{name}"})
    @ApiOperation(value="Get user info by username")
    public Response<UserInfo> getByName(@PathVariable String name) {
        return Response.success((Object)this.userService.getByName(name));
    }

    @PostMapping(value={"/user/listAll"})
    @ApiOperation(value="List all users")
    public Response<PageResult<UserInfo>> list(@RequestBody UserRequest request) {
        return Response.success((Object)this.userService.list(request));
    }

    @PostMapping(value={"/user/update"})
    @ApiOperation(value="Update user info")
    public Response<Integer> update(@Validated @RequestBody UserRequest userInfo) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.userService.update(userInfo, currentUser));
    }

    @DeleteMapping(value={"/user/delete"})
    @ApiOperation(value="Delete user by id")
    @RequiresRoles(value={"ADMIN"})
    public Response<Boolean> delete(@RequestParam(value="id") Integer id) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.userService.delete(id, currentUser));
    }
}

