/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.common.pojo.agent.TaskRequest;
import org.apache.inlong.common.pojo.agent.TaskResult;
import org.apache.inlong.common.pojo.agent.TaskSnapshotRequest;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.core.AgentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi"})
@Api(tags={"Open-Agent-API"})
public class AgentController {
    @Autowired
    private AgentService agentService;
    @Autowired
    private InlongClusterService clusterService;

    @PostMapping(value={"/agent/getManagerIpList"})
    @ApiOperation(value="Get inlong manager ip list")
    public Response<List<String>> getInLongManagerIp() {
        return Response.success((Object)this.clusterService.listNodeIpByType("inlong-openapi"));
    }

    @PostMapping(value={"/agent/reportSnapshot"})
    @ApiOperation(value="Report source task snapshot")
    public Response<Boolean> reportSnapshot(@RequestBody TaskSnapshotRequest request) {
        return Response.success((Object)this.agentService.reportSnapshot(request));
    }

    @PostMapping(value={"/agent/reportAndGetTask"})
    @ApiOperation(value="Report task result and get next tasks")
    public Response<TaskResult> reportAndGetTask(@RequestBody TaskRequest request) {
        this.agentService.report(request);
        return Response.success((Object)this.agentService.getTaskResult(request));
    }
}

