/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterPageRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi"})
@Api(tags={"Open-Cluster-API"})
public class OpenClusterController {
    @Autowired
    private InlongClusterService clusterService;

    @GetMapping(value={"/cluster/get/{id}"})
    @ApiOperation(value="Get cluster by id")
    @ApiImplicitParam(name="id", value="Cluster ID", dataTypeClass=Integer.class, required=true)
    public Response<ClusterInfo> get(@PathVariable Integer id) {
        return Response.success((Object)this.clusterService.get(id, "admin"));
    }

    @PostMapping(value={"/cluster/list"})
    @ApiOperation(value="Get clusters by paginating")
    public Response<PageResult<ClusterInfo>> list(@RequestBody ClusterPageRequest request) {
        return Response.success((Object)this.clusterService.list(request));
    }
}

