/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.auth;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.inlong.manager.common.auth.InlongShiro;
import org.apache.inlong.manager.service.user.UserService;
import org.apache.inlong.manager.web.auth.openapi.OpenAPIAuthenticatingRealm;
import org.apache.inlong.manager.web.auth.openapi.OpenAPIFilter;
import org.apache.inlong.manager.web.auth.web.AuthenticationFilter;
import org.apache.inlong.manager.web.auth.web.WebAuthorizingRealm;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.session.mgt.WebSessionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"type"}, prefix="inlong.auth", havingValue="default")
public class InlongShiroImpl
implements InlongShiro {
    private static final String FILTER_NAME_WEB = "authWeb";
    private static final String FILTER_NAME_API = "authAPI";
    @Autowired
    private UserService userService;
    @Value(value="${openapi.auth.enabled:false}")
    private Boolean openAPIAuthEnabled;

    public WebSecurityManager getWebSecurityManager() {
        return new DefaultWebSecurityManager();
    }

    public Collection<Realm> getShiroRealms() {
        WebAuthorizingRealm webRealm = new WebAuthorizingRealm(this.userService);
        webRealm.setCredentialsMatcher(this.getCredentialsMatcher());
        OpenAPIAuthenticatingRealm apiRealm = new OpenAPIAuthenticatingRealm(this.userService);
        return Arrays.asList(new Realm[]{webRealm, apiRealm});
    }

    public WebSessionManager getWebSessionManager() {
        return new DefaultWebSessionManager();
    }

    public CredentialsMatcher getCredentialsMatcher() {
        HashedCredentialsMatcher hashedCredentialsMatcher = new HashedCredentialsMatcher();
        hashedCredentialsMatcher.setHashAlgorithmName("SHA-256");
        hashedCredentialsMatcher.setHashIterations(1024);
        return hashedCredentialsMatcher;
    }

    public ShiroFilterFactoryBean getShiroFilter(SecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        LinkedHashMap<String, Object> filters = new LinkedHashMap<String, Object>();
        filters.put(FILTER_NAME_WEB, new AuthenticationFilter());
        shiroFilterFactoryBean.setFilters(filters);
        LinkedHashMap<String, String> pathDefinitions = new LinkedHashMap<String, String>();
        pathDefinitions.put("/api/anno/**/*", "anon");
        pathDefinitions.put("/doc.html", "anon");
        pathDefinitions.put("/v2/api-docs/**/**", "anon");
        pathDefinitions.put("/webjars/**/*", "anon");
        pathDefinitions.put("/swagger-resources/**/*", "anon");
        pathDefinitions.put("/swagger-resources", "anon");
        if (this.openAPIAuthEnabled.booleanValue()) {
            filters.put(FILTER_NAME_API, new OpenAPIFilter());
            pathDefinitions.put("/openapi/**/*", FILTER_NAME_API);
        } else {
            pathDefinitions.put("/openapi/**/*", "anon");
        }
        pathDefinitions.put("/**", FILTER_NAME_WEB);
        shiroFilterFactoryBean.setFilterChainDefinitionMap(pathDefinitions);
        return shiroFilterFactoryBean;
    }

    public AuthorizationAttributeSourceAdvisor getAuthorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(securityManager);
        return authorizationAttributeSourceAdvisor;
    }
}

