/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.auth.openapi;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import org.apache.inlong.manager.common.enums.UserTypeEnum;
import org.apache.inlong.manager.common.util.AESUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.service.user.UserService;
import org.apache.inlong.manager.web.auth.openapi.SecretToken;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIAuthenticatingRealm
extends AuthenticatingRealm {
    private static final Logger log = LoggerFactory.getLogger(OpenAPIAuthenticatingRealm.class);
    private final UserService userService;

    public OpenAPIAuthenticatingRealm(UserService userService) {
        this.userService = userService;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        SecretToken upToken = (SecretToken)authenticationToken;
        String username = upToken.getSecretId();
        UserInfo userInfo = this.userService.getByName(username);
        Preconditions.expectNotNull((Object)userInfo, (String)"User doesn't exist");
        Preconditions.expectTrue((boolean)userInfo.getDueDate().after(new Date()), (String)"user has expired");
        try {
            String secretKey = new String(AESUtils.decryptAsString((String)userInfo.getSecretKey(), (Integer)userInfo.getEncryptVersion()));
            userInfo.setRoles((Set)Sets.newHashSet((Object[])new String[]{userInfo.getAccountType() == 0 ? UserTypeEnum.ADMIN.name() : UserTypeEnum.OPERATOR.name()}));
            return new SimpleAuthenticationInfo((Object)userInfo, (Object)secretKey, this.getName());
        }
        catch (Exception e) {
            log.error("decrypt secret key fail: ", (Throwable)e);
            throw new AuthenticationException("internal error: " + e.getMessage());
        }
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof SecretToken;
    }
}

