/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.auth.openapi;

import java.io.IOException;
import java.util.Base64;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.service.user.LoginUserUtils;
import org.apache.inlong.manager.web.auth.openapi.SecretToken;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(OpenAPIFilter.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIFilter.class);

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        Subject subject = SecurityUtils.getSubject();
        try {
            SecretToken token = this.parseBasicAuth(httpServletRequest);
            subject.login((AuthenticationToken)token);
        }
        catch (Exception ex) {
            LOGGER.error("login error: {}", (Object)ex.getMessage());
            ((HttpServletResponse)servletResponse).sendError(403, ex.getMessage());
            return;
        }
        if (!subject.isAuthenticated()) {
            log.error("Access denied for anonymous user:{}, path:{} ", subject.getPrincipal(), (Object)httpServletRequest.getServletPath());
            ((HttpServletResponse)servletResponse).sendError(403);
            return;
        }
        LoginUserUtils.setUserLoginInfo((UserInfo)((UserInfo)subject.getPrincipal()));
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            LoginUserUtils.removeUserLoginInfo();
        }
    }

    private SecretToken parseBasicAuth(HttpServletRequest servletRequest) {
        String basicAuth = servletRequest.getHeader("Authorization");
        if (StringUtils.isBlank((String)basicAuth)) {
            log.error("basic auth header is empty");
            return null;
        }
        String[] parts = basicAuth.split(" ");
        if (parts.length != 2) {
            log.error("the length parts size error: {}", (Object)parts.length);
            return null;
        }
        if (!parts[0].equals("Basic")) {
            log.error("prefix error: {}", (Object)parts[0]);
            return null;
        }
        String joinedPair = new String(Base64.getDecoder().decode(parts[1]));
        String[] pair = joinedPair.split(":");
        if (pair.length != 2) {
            log.error("pair format error: {}", (Object)pair.length);
            return null;
        }
        String secretId = pair[0];
        String secretKey = pair[1];
        if (StringUtils.isBlank((String)secretId) || StringUtils.isBlank((String)secretKey)) {
            log.error("invalid id = {} or key = {}", (Object)secretId, (Object)secretKey);
            return null;
        }
        return new SecretToken(secretId, secretKey);
    }

    public void destroy() {
    }
}

