/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.auth.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.service.user.LoginUserUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationFilter.class);
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationFilter.class);

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            UserInfo loginUserInfo = (UserInfo)subject.getPrincipal();
            this.doFilter(servletRequest, servletResponse, filterChain, loginUserInfo);
            return;
        }
        try {
            UsernamePasswordToken token = this.getPasswordToken(servletRequest);
            subject.login((AuthenticationToken)token);
        }
        catch (Exception ex) {
            LOGGER.error("login error: {}", (Object)ex.getMessage());
            ((HttpServletResponse)servletResponse).sendError(403, ex.getMessage());
            return;
        }
        if (!subject.isAuthenticated()) {
            log.error("Access denied for anonymous user:{}, path:{} ", subject.getPrincipal(), (Object)httpServletRequest.getServletPath());
            ((HttpServletResponse)servletResponse).sendError(403);
            return;
        }
        this.doFilter(servletRequest, servletResponse, filterChain, (UserInfo)subject.getPrincipal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain, UserInfo userInfo) throws IOException, ServletException {
        LoginUserUtils.setUserLoginInfo((UserInfo)userInfo);
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            LoginUserUtils.removeUserLoginInfo();
        }
    }

    private UsernamePasswordToken getPasswordToken(ServletRequest servletRequest) {
        String username = servletRequest.getParameter(USERNAME);
        String password = servletRequest.getParameter(PASSWORD);
        Preconditions.expectNotBlank((String)username, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"please input username");
        Preconditions.expectNotNull((Object)password, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"please input password");
        return new UsernamePasswordToken(username, password);
    }

    public void destroy() {
    }
}

