/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.enums.ProcessEvent;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.workflow.EventLogRequest;
import org.apache.inlong.manager.pojo.workflow.EventLogResponse;
import org.apache.inlong.manager.service.core.WorkflowEventService;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"Workflow-Event-API"})
public class WorkflowEventController {
    @Autowired
    private WorkflowEventService workflowEventService;

    @GetMapping(value={"/workflow/event/detail/{id}"})
    @ApiOperation(value="Get event details")
    @ApiImplicitParam(name="id", value="Event ID", dataTypeClass=Integer.class, required=true)
    public Response<EventLogResponse> get(@PathVariable Integer id) {
        return Response.success((Object)this.workflowEventService.get(id));
    }

    @GetMapping(value={"/workflow/event/list"})
    @ApiOperation(value="Get event list by paginating")
    public Response<PageResult<EventLogResponse>> list(EventLogRequest query) {
        return Response.success((Object)this.workflowEventService.list(query));
    }

    @Deprecated
    @PostMapping(value={"/workflow/event/executeEventListener/{id}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Execute the listener based on the event log ID")
    @ApiImplicitParam(name="id", value="Event log ID", dataTypeClass=Integer.class, required=true)
    public Response<Object> executeEventListener(@PathVariable Integer id) {
        this.workflowEventService.executeEventListener(id);
        return Response.success();
    }

    @Deprecated
    @PostMapping(value={"/workflow/event/executeProcessEventListener"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Re-execute the specified listener based on the process ID")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processId", value="Process ID", dataTypeClass=Integer.class), @ApiImplicitParam(name="listenerName", value="Listener name", dataTypeClass=String.class)})
    public Response<Object> executeProcessEventListener(@RequestParam Integer processId, @RequestParam String listenerName) {
        this.workflowEventService.executeProcessEventListener(processId, listenerName);
        return Response.success();
    }

    @Deprecated
    @PostMapping(value={"/workflow/event/executeTaskEventListener"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Re-execute the specified listener based on the task ID")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="Task ID", dataTypeClass=Integer.class), @ApiImplicitParam(name="listenerName", value="Listener name", dataTypeClass=String.class)})
    public Response<Object> executeTaskEventListener(Integer taskId, String listenerName) {
        this.workflowEventService.executeTaskEventListener(taskId, listenerName);
        return Response.success();
    }

    @Deprecated
    @PostMapping(value={"/workflow/event/triggerProcessEvent"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Re-trigger the process event based on the process ID")
    public Response<Object> triggerProcessEvent(@ApiParam(value="process id", required=true) Integer processId, @ApiParam(value="process event", required=true) ProcessEvent processEvent) {
        this.workflowEventService.triggerProcessEvent(processId, processEvent);
        return Response.success();
    }

    @Deprecated
    @PostMapping(value={"/workflow/event/triggerTaskEvent"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Re-trigger the task event based on the task ID")
    public Response<Object> triggerTaskEvent(@ApiParam(value="task id", required=true) Integer taskId, @ApiParam(value="task event", required=true) TaskEvent taskEvent) {
        this.workflowEventService.triggerTaskEvent(taskId, taskEvent);
        return Response.success();
    }
}

