/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.common.pojo.audit.AuditConfig;
import org.apache.inlong.common.pojo.audit.AuditConfigRequest;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="OpenAuditController")
@RequestMapping(value={"/openapi"})
@Api(tags={"Open-Audit-API"})
public class AuditController {
    @Autowired
    private InlongClusterService clusterService;

    @PostMapping(value={"/audit/getConfig"})
    @ApiOperation(value="Get mq config list")
    public Response<AuditConfig> getConfig(@RequestBody AuditConfigRequest request) {
        AuditConfig auditConfig = this.clusterService.getAuditConfig(request.getClusterTag());
        if (CollectionUtils.isEmpty((Collection)auditConfig.getMqInfoList())) {
            return Response.fail((String)("Failed to get MQ config of cluster tag: " + request.getClusterTag()));
        }
        return Response.success((Object)auditConfig);
    }
}

