/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.common.validation.SaveValidation;
import org.apache.inlong.manager.common.validation.UpdateByIdValidation;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodePageRequest;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.service.node.DataNodeService;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.apache.inlong.manager.service.user.LoginUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi"})
@Api(tags={"Open-DataNode-API"})
public class OpenDataNodeController {
    @Autowired
    private DataNodeService dataNodeService;

    @GetMapping(value={"/node/get/{id}"})
    @ApiOperation(value="Get node by id")
    @ApiImplicitParam(name="id", value="Data node ID", dataTypeClass=Integer.class, required=true)
    public Response<DataNodeInfo> get(@PathVariable Integer id) {
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"data node id cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.dataNodeService.get(id, LoginUserUtils.getLoginUser()));
    }

    @PostMapping(value={"/node/list"})
    @ApiOperation(value="List data node")
    public Response<List<DataNodeInfo>> list(@RequestBody DataNodePageRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.dataNodeService.list(request, LoginUserUtils.getLoginUser()));
    }

    @PostMapping(value={"/node/save"})
    @ApiOperation(value="Save node")
    @OperationLog(operation=OperationType.CREATE)
    public Response<Integer> save(@Validated(value={SaveValidation.class}) @RequestBody DataNodeRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.dataNodeService.save(request, LoginUserUtils.getLoginUser()));
    }

    @PostMapping(value={"/node/update"})
    @ApiOperation(value="Update data node")
    @OperationLog(operation=OperationType.UPDATE)
    public Response<Boolean> update(@Validated(value={UpdateByIdValidation.class}) @RequestBody DataNodeRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.REQUEST_IS_EMPTY);
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.dataNodeService.update(request, LoginUserUtils.getLoginUser()));
    }

    @DeleteMapping(value={"/node/delete/{id}"})
    @ApiOperation(value="Delete data node by id")
    @OperationLog(operation=OperationType.DELETE)
    @ApiImplicitParam(name="id", value="Data node ID", dataTypeClass=Integer.class, required=true)
    public Response<Boolean> delete(@PathVariable Integer id) {
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"data node id cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.dataNodeService.delete(id, LoginUserUtils.getLoginUser()));
    }
}

