/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.common.validation.SaveValidation;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.source.SourcePageRequest;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.apache.inlong.manager.service.user.LoginUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi"})
@Api(tags={"Open-StreamSource-API"})
public class OpenStreamSourceController {
    @Autowired
    StreamSourceService sourceService;

    @RequestMapping(value={"/source/get/{id}"}, method={RequestMethod.GET})
    @ApiOperation(value="Get stream source")
    @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)
    public Response<StreamSource> get(@PathVariable Integer id) {
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"sourceId cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.sourceService.get(id, LoginUserUtils.getLoginUser()));
    }

    @RequestMapping(value={"/source/list"}, method={RequestMethod.POST})
    @ApiOperation(value="List stream sources by paginating")
    public Response<PageResult<? extends StreamSource>> listByCondition(@RequestBody SourcePageRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.sourceService.listByCondition(request, LoginUserUtils.getLoginUser()));
    }

    @RequestMapping(value={"/source/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Save stream source")
    public Response<Integer> save(@Validated(value={SaveValidation.class}) @RequestBody SourceRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.sourceService.save(request, LoginUserUtils.getLoginUser()));
    }

    @RequestMapping(value={"/source/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Update stream source")
    public Response<Boolean> update(@Validated(value={UpdateValidation.class}) @RequestBody SourceRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.sourceService.update(request, LoginUserUtils.getLoginUser()));
    }

    @RequestMapping(value={"/source/delete/{id}"}, method={RequestMethod.DELETE})
    @OperationLog(operation=OperationType.DELETE)
    @ApiOperation(value="Delete stream source")
    @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)
    public Response<Boolean> delete(@PathVariable Integer id) {
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"sourceId cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.sourceService.delete(id, LoginUserUtils.getLoginUser()));
    }

    @RequestMapping(value={"/source/stop/{id}"}, method={RequestMethod.POST})
    @ApiOperation(value="Stop stream source")
    @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)
    public Response<Boolean> stop(@PathVariable Integer id) {
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"sourceId cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        boolean result = this.sourceService.stop(id, LoginUserUtils.getLoginUser().getName());
        return Response.success((Object)result);
    }

    @RequestMapping(value={"/source/restart/{id}"}, method={RequestMethod.POST})
    @ApiOperation(value="Restart stream source")
    @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)
    public Response<Boolean> restart(@PathVariable Integer id) {
        Preconditions.expectNotNull((Object)id, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"sourceId cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        boolean result = this.sourceService.restart(id, LoginUserUtils.getLoginUser().getName());
        return Response.success((Object)result);
    }
}

