/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.common.pojo.sdk.SortSourceConfigResponse;
import org.apache.inlong.common.pojo.sortstandalone.SortClusterResponse;
import org.apache.inlong.manager.service.core.SortService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi"})
@Api(tags={"Open-Sort-API"})
public class SortController {
    @Autowired
    private SortService sortService;

    @GetMapping(value={"/sort/getClusterConfig"})
    @ApiOperation(value="get sort cluster config")
    public SortClusterResponse getSortClusterConfig(@RequestParam String clusterName, @RequestParam String md5) {
        return this.sortService.getClusterConfig(clusterName, md5);
    }

    @GetMapping(value={"/sort/getSortSource"})
    @ApiOperation(value="get sort sdk config")
    public SortSourceConfigResponse getSortSourceConfig(@RequestParam String clusterName, @RequestParam String sortTaskId, @RequestParam String md5) {
        return this.sortService.getSourceConfig(clusterName, sortTaskId, md5);
    }
}

