/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.tsfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.iotdb.flink.tsfile.TSRecordConverter;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.BooleanDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.StringDataPoint;
import org.apache.iotdb.tsfile.write.schema.Schema;

public class RowTSRecordConverter
implements TSRecordConverter<Row> {
    private RowTypeInfo rowTypeInfo;
    private transient TSRecord[] outputTemplate;
    private transient int timeIndex = -1;
    private transient int[] tsRecordIndexMapping;
    private transient int[] dataPointIndexMapping;
    private transient TSRecord[] reuse;

    public RowTSRecordConverter(RowTypeInfo rowTypeInfo) {
        this.rowTypeInfo = rowTypeInfo;
    }

    @Override
    public void open(Schema schema) throws IOException {
        int i;
        this.tsRecordIndexMapping = new int[this.rowTypeInfo.getArity()];
        this.dataPointIndexMapping = new int[this.rowTypeInfo.getArity()];
        ArrayList<TSRecord> outputTemplateList = new ArrayList<TSRecord>();
        for (i = 0; i < this.rowTypeInfo.getArity(); ++i) {
            String fieldName = this.rowTypeInfo.getFieldNames()[i];
            if ("time".equals(fieldName)) {
                this.timeIndex = i;
                this.tsRecordIndexMapping[i] = -1;
                this.dataPointIndexMapping[i] = -1;
                continue;
            }
            String deviceId = fieldName.substring(0, fieldName.lastIndexOf("."));
            String measurementId = fieldName.substring(fieldName.lastIndexOf(".") + 1);
            int tsRecordIndex = outputTemplateList.stream().map(t -> t.deviceId).collect(Collectors.toList()).indexOf(deviceId);
            if (tsRecordIndex < 0) {
                outputTemplateList.add(new TSRecord(0L, deviceId));
                tsRecordIndex = outputTemplateList.size() - 1;
            }
            this.tsRecordIndexMapping[i] = tsRecordIndex;
            TSRecord tsRecord = (TSRecord)outputTemplateList.get(tsRecordIndex);
            Class typeClass = this.rowTypeInfo.getFieldTypes()[i].getTypeClass();
            if (typeClass == Boolean.class || typeClass == Boolean.TYPE) {
                tsRecord.addTuple((DataPoint)new BooleanDataPoint(measurementId, false));
            } else if (typeClass == Integer.class || typeClass == Integer.TYPE) {
                tsRecord.addTuple((DataPoint)new IntDataPoint(measurementId, 0));
            } else if (typeClass == Long.class || typeClass == Long.TYPE) {
                tsRecord.addTuple((DataPoint)new LongDataPoint(measurementId, 0L));
            } else if (typeClass == Float.class || typeClass == Float.TYPE) {
                tsRecord.addTuple((DataPoint)new FloatDataPoint(measurementId, 0.0f));
            } else if (typeClass == Double.class || typeClass == Double.TYPE) {
                tsRecord.addTuple((DataPoint)new DoubleDataPoint(measurementId, 0.0));
            } else if (typeClass == String.class) {
                tsRecord.addTuple((DataPoint)new StringDataPoint(measurementId, null));
            } else {
                throw new UnSupportedDataTypeException(typeClass.toString());
            }
            this.dataPointIndexMapping[i] = tsRecord.dataPointList.size() - 1;
        }
        this.outputTemplate = outputTemplateList.toArray(new TSRecord[0]);
        this.reuse = new TSRecord[this.outputTemplate.length];
        for (i = 0; i < this.outputTemplate.length; ++i) {
            this.reuse[i] = new TSRecord(0L, this.outputTemplate[i].deviceId);
        }
    }

    @Override
    public void convert(Row input, Collector<TSRecord> collector) throws IOException {
        long timestamp = (Long)input.getField(this.timeIndex);
        for (TSRecord tsRecord : this.reuse) {
            tsRecord.dataPointList.clear();
        }
        for (int i = 0; i < input.getArity(); ++i) {
            if (i == this.timeIndex) continue;
            TSRecord templateRecord = this.outputTemplate[this.tsRecordIndexMapping[i]];
            DataPoint templateDataPoint = (DataPoint)templateRecord.dataPointList.get(this.dataPointIndexMapping[i]);
            Object o = input.getField(i);
            if (o == null) continue;
            switch (templateDataPoint.getType()) {
                case BOOLEAN: {
                    templateDataPoint.setBoolean(((Boolean)o).booleanValue());
                    break;
                }
                case INT32: {
                    templateDataPoint.setInteger(((Integer)o).intValue());
                    break;
                }
                case INT64: {
                    templateDataPoint.setLong(((Long)o).longValue());
                    break;
                }
                case FLOAT: {
                    templateDataPoint.setFloat(((Float)o).floatValue());
                    break;
                }
                case DOUBLE: {
                    templateDataPoint.setDouble(((Double)o).doubleValue());
                    break;
                }
                case TEXT: {
                    templateDataPoint.setString(Binary.valueOf((String)((String)o)));
                    break;
                }
                default: {
                    templateDataPoint.setString(Binary.valueOf((String)o.toString()));
                }
            }
            this.reuse[this.tsRecordIndexMapping[i]].addTuple(templateDataPoint);
        }
        for (TSRecord tsRecord : this.reuse) {
            if (tsRecord.dataPointList.size() <= 0) continue;
            tsRecord.setTime(timestamp);
            collector.collect((Object)tsRecord);
        }
    }

    @Override
    public void close() throws IOException {
        this.outputTemplate = null;
        this.timeIndex = -1;
        this.tsRecordIndexMapping = null;
        this.dataPointIndexMapping = null;
    }
}

