/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.tsfile;

import java.io.IOException;
import org.apache.flink.util.Collector;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.iotdb.flink.tsfile.TSRecordConverter;
import org.apache.iotdb.flink.tsfile.TsFileOutputFormat;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.schema.Schema;

public class TSRecordOutputFormat<T>
extends TsFileOutputFormat<T> {
    private final TSRecordConverter<T> converter;
    private transient TSRecordCollector tsRecordCollector = null;

    public TSRecordOutputFormat(String path, Schema schema, TSRecordConverter<T> converter) {
        this(path, schema, converter, null);
    }

    public TSRecordOutputFormat(Schema schema, TSRecordConverter<T> converter) {
        super(null, schema, null);
        this.converter = converter;
    }

    public TSRecordOutputFormat(String path, Schema schema, TSRecordConverter<T> converter, TSFileConfig config) {
        super(path, schema, config);
        this.converter = converter;
    }

    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        super.open(taskNumber, numTasks);
        this.converter.open(this.schema);
        this.tsRecordCollector = new TSRecordCollector();
    }

    @Override
    public void close() throws IOException {
        this.converter.close();
        super.close();
    }

    public void writeRecord(T t) throws IOException {
        try {
            this.converter.convert(t, this.tsRecordCollector);
        }
        catch (FlinkRuntimeException e) {
            throw new IOException(e.getCause());
        }
    }

    public TSRecordConverter<T> getConverter() {
        return this.converter;
    }

    private class TSRecordCollector
    implements Collector<TSRecord> {
        private TSRecordCollector() {
        }

        public void collect(TSRecord tsRecord) {
            try {
                TSRecordOutputFormat.this.writer.write(tsRecord);
            }
            catch (IOException | WriteProcessException e) {
                throw new FlinkRuntimeException(e);
            }
        }

        public void close() {
        }
    }
}

