/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.tsfile;

import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.util.Preconditions;
import org.apache.iotdb.flink.tsfile.util.TSFileConfigUtil;
import org.apache.iotdb.hadoop.fileSystem.HDFSOutput;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.apache.iotdb.tsfile.write.writer.LocalTsFileOutput;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;

public abstract class TsFileOutputFormat<T>
extends FileOutputFormat<T> {
    protected Schema schema;
    @Nullable
    protected TSFileConfig config;
    protected transient org.apache.hadoop.conf.Configuration hadoopConf = null;
    protected transient TsFileWriter writer = null;

    public TsFileOutputFormat(String path, Schema schema, TSFileConfig config) {
        super(path == null ? null : new Path(path));
        this.schema = (Schema)Preconditions.checkNotNull((Object)schema);
        this.config = config;
    }

    public void configure(Configuration flinkConfiguration) {
        super.configure(flinkConfiguration);
        this.hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)flinkConfiguration);
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        Object out;
        super.open(taskNumber, numTasks);
        if (this.config != null) {
            TSFileConfigUtil.setGlobalTSFileConfig(this.config);
        }
        this.stream.close();
        Path actualFilePath = this.getAcutalFilePath();
        try {
            out = actualFilePath.getFileSystem().isDistributedFS() ? new HDFSOutput(new org.apache.hadoop.fs.Path(new URI(actualFilePath.getPath())), this.hadoopConf, true) : new LocalTsFileOutput(new FileOutputStream(actualFilePath.getPath()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.writer = new TsFileWriter((TsFileOutput)out, this.schema);
    }

    public void close() throws IOException {
        super.close();
        this.writer.close();
        this.writer = null;
    }

    protected String getDirectoryFileName(int taskNumber) {
        return super.getDirectoryFileName(taskNumber) + ".tsfile";
    }

    protected Path getAcutalFilePath() {
        try {
            Field field = FileOutputFormat.class.getDeclaredField("actualFilePath");
            field.setAccessible(true);
            return (Path)field.get((Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Get actual file path failed!", e);
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Optional<TSFileConfig> getConfig() {
        return Optional.ofNullable(this.config);
    }
}

