/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.tsfile;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.iotdb.flink.tsfile.RowRecordParser;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;

public class RowRowRecordParser
implements RowRecordParser<Row>,
ResultTypeQueryable<Row> {
    private final int[] indexMapping;
    private final RowTypeInfo rowTypeInfo;

    public RowRowRecordParser(int[] indexMapping, RowTypeInfo rowTypeInfo) {
        this.indexMapping = indexMapping;
        this.rowTypeInfo = rowTypeInfo;
    }

    @Override
    public Row parse(RowRecord rowRecord, Row reuse) {
        List fields = rowRecord.getFields();
        for (int i = 0; i < this.indexMapping.length; ++i) {
            if (this.indexMapping[i] < 0) {
                reuse.setField(i, (Object)rowRecord.getTimestamp());
                continue;
            }
            reuse.setField(i, this.toSqlValue((Field)fields.get(this.indexMapping[i])));
        }
        return reuse;
    }

    private Object toSqlValue(Field field) {
        if (field == null) {
            return null;
        }
        if (field.getDataType() == null) {
            return null;
        }
        switch (field.getDataType()) {
            case BOOLEAN: {
                return field.getBoolV();
            }
            case INT32: {
                return field.getIntV();
            }
            case INT64: {
                return field.getLongV();
            }
            case FLOAT: {
                return Float.valueOf(field.getFloatV());
            }
            case DOUBLE: {
                return field.getDoubleV();
            }
            case TEXT: {
                return field.getStringValue();
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported type %s", field.getDataType()));
    }

    public TypeInformation<Row> getProducedType() {
        return this.rowTypeInfo;
    }

    public static RowRowRecordParser create(RowTypeInfo outputRowTypeInfo, List<Path> selectedSeries) {
        List selectedSeriesNames = selectedSeries.stream().map(Path::toString).collect(Collectors.toList());
        String[] rowFieldNames = outputRowTypeInfo.getFieldNames();
        int[] indexMapping = new int[outputRowTypeInfo.getArity()];
        for (int i = 0; i < outputRowTypeInfo.getArity(); ++i) {
            if (!"time".equals(rowFieldNames[i])) {
                int index = selectedSeriesNames.indexOf(rowFieldNames[i]);
                if (index >= 0) {
                    indexMapping[i] = index;
                    continue;
                }
                throw new IllegalArgumentException(rowFieldNames[i] + " is not found in selected series.");
            }
            indexMapping[i] = -1;
        }
        return new RowRowRecordParser(indexMapping, outputRowTypeInfo);
    }
}

