/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.tsfile;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.iotdb.flink.tsfile.RowRecordParser;
import org.apache.iotdb.flink.tsfile.util.TSFileConfigUtil;
import org.apache.iotdb.hadoop.fileSystem.HDFSInput;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.read.TsFileReader;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.reader.LocalTsFileInput;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;

public class TsFileInputFormat<T>
extends FileInputFormat<T>
implements ResultTypeQueryable<T> {
    private final QueryExpression expression;
    private final RowRecordParser<T> parser;
    @Nullable
    private final TSFileConfig config;
    private transient org.apache.hadoop.conf.Configuration hadoopConf = null;
    private transient TsFileReader readTsFile = null;
    private transient QueryDataSet queryDataSet = null;

    public TsFileInputFormat(@Nullable String path, QueryExpression expression, RowRecordParser<T> parser, @Nullable TSFileConfig config) {
        super(path != null ? new Path(path) : null);
        this.expression = expression;
        this.parser = parser;
        this.config = config;
    }

    public TsFileInputFormat(@Nullable String path, QueryExpression expression, RowRecordParser<T> parser) {
        this(path, expression, parser, null);
    }

    public TsFileInputFormat(QueryExpression expression, RowRecordParser<T> parser) {
        this(null, expression, parser, null);
    }

    public void configure(Configuration flinkConfiguration) {
        super.configure(flinkConfiguration);
        this.hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)flinkConfiguration);
    }

    public void open(FileInputSplit split) throws IOException {
        Object in;
        super.open(split);
        if (this.config != null) {
            TSFileConfigUtil.setGlobalTSFileConfig(this.config);
        }
        try {
            in = this.currentSplit.getPath().getFileSystem().isDistributedFS() ? new HDFSInput(new org.apache.hadoop.fs.Path(new URI(this.currentSplit.getPath().getPath())), this.hadoopConf) : new LocalTsFileInput(Paths.get(this.currentSplit.getPath().toUri()));
        }
        catch (URISyntaxException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
        try (TsFileSequenceReader reader = new TsFileSequenceReader((TsFileInput)in);){
            this.readTsFile = new TsFileReader(reader);
            this.queryDataSet = this.readTsFile.query(QueryExpression.create((List)this.expression.getSelectedSeries(), (IExpression)this.expression.getExpression()), this.currentSplit.getStart(), this.currentSplit.getStart() + this.currentSplit.getLength());
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.readTsFile != null) {
            this.readTsFile.close();
            this.readTsFile = null;
        }
    }

    public boolean reachedEnd() throws IOException {
        return !this.queryDataSet.hasNext();
    }

    public T nextRecord(T t) throws IOException {
        RowRecord rowRecord = this.queryDataSet.next();
        return this.parser.parse(rowRecord, t);
    }

    public boolean supportsMultiPaths() {
        return true;
    }

    public QueryExpression getExpression() {
        return this.expression;
    }

    public RowRecordParser<T> getParser() {
        return this.parser;
    }

    public Optional<TSFileConfig> getConfig() {
        return Optional.ofNullable(this.config);
    }

    public TypeInformation<T> getProducedType() {
        if (this.getParser() instanceof ResultTypeQueryable) {
            return ((ResultTypeQueryable)this.getParser()).getProducedType();
        }
        return TypeExtractor.createTypeInfo(RowRecordParser.class, this.getParser().getClass(), (int)0, null, null);
    }
}

